/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.gadgets.system.AbstractResource;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class SearchQueryBackedResource
extends AbstractResource {
    protected static final String QUERY_STRING = "projectOrFilterId";
    static final String PROJECT = "project";
    private static final String SEARCH_REQUEST = "searchRequest";
    protected final ChartUtils chartUtils;
    protected final JiraAuthenticationContext authenticationContext;
    protected final PermissionManager permissionManager;
    private VelocityRequestContextFactory velocityRequestContextFactory;
    protected final SearchService searchService;
    private static final String FILTER_PREFIX = "filter-";
    private static final String PROJECT_PREFIX = "project-";
    private static final String JQL_PREFIX = "jql-";

    public SearchQueryBackedResource(ChartUtils chartUtils, JiraAuthenticationContext authenticationContext, SearchService searchService, PermissionManager permissionManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.chartUtils = chartUtils;
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.permissionManager = permissionManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    protected SearchRequest getSearchRequestAndValidate(String queryString, Collection<ValidationError> errors, Map<String, Object> params) {
        SearchRequest searchRequest;
        if (StringUtils.isNotEmpty((String)queryString)) {
            params.put(QUERY_STRING, queryString);
            searchRequest = this.chartUtils.retrieveOrMakeSearchRequest(queryString, params);
            this.validateParams(errors, params);
            if (!errors.isEmpty()) {
                searchRequest = null;
            }
        } else {
            errors.add(new ValidationError(QUERY_STRING, "dashboard.item.error.required.query"));
            searchRequest = null;
        }
        return searchRequest;
    }

    private void validateParams(Collection<ValidationError> errors, Map<String, Object> params) {
        String queryString = (String)params.get(QUERY_STRING);
        if (queryString.startsWith(FILTER_PREFIX)) {
            if (params.get(SEARCH_REQUEST) == null) {
                errors.add(new ValidationError(QUERY_STRING, "dashboard.item.error.invalid.filter"));
            }
        } else if (queryString.startsWith(PROJECT_PREFIX)) {
            if (params.get(PROJECT) == null) {
                errors.add(new ValidationError(QUERY_STRING, "dashboard.item.error.invalid.project"));
            } else if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Project)params.get(PROJECT), this.authenticationContext.getLoggedInUser())) {
                errors.add(new ValidationError(QUERY_STRING, "dashboard.item.error.invalid.project"));
            }
        } else if (queryString.startsWith(JQL_PREFIX)) {
            if (params.get(SEARCH_REQUEST) == null) {
                errors.add(new ValidationError(QUERY_STRING, "dashboard.item.error.invalid.jql"));
            }
        } else {
            errors.add(new ValidationError(QUERY_STRING, "dashboard.item.error.invalid.projectOrFilterId"));
        }
    }

    protected String getFilterTitle(Map<String, Object> params) {
        if (params.containsKey(PROJECT)) {
            return ((Project)params.get(PROJECT)).getName();
        }
        if (params.containsKey(SEARCH_REQUEST)) {
            return ((SearchRequest)params.get(SEARCH_REQUEST)).getName();
        }
        return "dashboard.item.anonymous.filter";
    }

    protected String getFilterUrl(Map<String, Object> params) {
        if (params.containsKey(PROJECT)) {
            Project project = (Project)params.get(PROJECT);
            Query query = JqlQueryBuilder.newBuilder().where().project().eq(project.getKey()).buildQuery();
            return this.searchService.getIssueSearchPath(this.authenticationContext.getLoggedInUser(), SearchService.IssueSearchParameters.builder().query(query).build());
        }
        if (params.containsKey(SEARCH_REQUEST)) {
            SearchRequest request = (SearchRequest)params.get(SEARCH_REQUEST);
            if (request != null && request.isLoaded() && request.getId() != null) {
                return this.searchService.getIssueSearchPath(this.authenticationContext.getLoggedInUser(), SearchService.IssueSearchParameters.builder().filterId(request.getId()).build());
            }
            return this.searchService.getIssueSearchPath(this.authenticationContext.getLoggedInUser(), SearchService.IssueSearchParameters.builder().query((Query)(request == null ? new QueryImpl() : request.getQuery())).build());
        }
        return "";
    }

    String createIndexingUnavailableMessage() {
        String msg2;
        String msg1 = this.authenticationContext.getI18nHelper().getText("dashboard.item.indexing.not.configured");
        if (this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser())) {
            String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            msg2 = this.authenticationContext.getI18nHelper().getText("dashboard.item.indexing.configure", "<a href=\"" + baseUrl + "/secure/admin/jira/IndexAdmin.jspa\">", "</a>");
        } else {
            msg2 = this.authenticationContext.getI18nHelper().getText("dashboard.item.indexing.admin");
        }
        return msg1 + " " + msg2;
    }
}

