/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.gadgets.system.AbstractResource;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.DateTime;

@Path(value="roadmap")
@AnonymousAllowed
@Produces(value={"application/json"})
public class RoadMapResource
extends AbstractResource {
    public static final String ALL_PROJECTS = "allprojects";
    public static final int DEFAULT_DAYS_MAX_INCL = 1000;
    public static final int DEFAULT_NUM_MAX_INCL = 50;
    private static final ToStringStyle TO_STRING_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;
    static final String CATEGORY = "cat";
    static final String PROJECT_OR_CATEGORY_IDS = "projectsOrCategories";
    static final String DAYS = "days";
    static final String NUM = "num";
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final SearchService searchService;
    private final MauEventService mauEventService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final DateTimeFormatter dateTimeFormatter;

    public RoadMapResource(@ComponentImport JiraAuthenticationContext authCtx, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport VersionManager versionManager, @ComponentImport SearchService searchService, @ComponentImport MauEventService mauEventService, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport DateTimeFormatter dateTimeFormatter) {
        this.authenticationContext = authCtx;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.searchService = searchService;
        this.mauEventService = mauEventService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @GET
    @Path(value="/validate")
    public Response validate(@QueryParam(value="projectsOrCategories") String projectsOrCategories, @QueryParam(value="days") @DefaultValue(value="30") String days, @QueryParam(value="num") @DefaultValue(value="10") String num) {
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateProjectsAndCategories(projectsOrCategories, errors);
        this.validateDays(days, errors);
        this.validateNum(num, errors);
        return this.createValidationResponse(errors);
    }

    private void validateProjectsAndCategories(String projectsOrCategories, Collection<ValidationError> errors) {
        List<String> projectAndCategoryIds = this.splitProjectAndCategoryIds(projectsOrCategories);
        if (projectAndCategoryIds.contains(ALL_PROJECTS)) {
            return;
        }
        Set<Long> selectedProjectIds = RoadMapResource.filterProjectIds(projectAndCategoryIds);
        for (Long projectId : selectedProjectIds) {
            if (this.projectManager.getProjectObj(projectId) != null) continue;
            errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.invalid.project"));
        }
        Set<Long> selectedCategoryIds = RoadMapResource.filterProjectCategoryIds(projectAndCategoryIds);
        for (Long catId : selectedCategoryIds) {
            if (this.projectManager.getProjectCategory(catId) != null) continue;
            errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.invalid.projectCategory"));
        }
        if (selectedProjectIds.isEmpty() && selectedCategoryIds.isEmpty()) {
            errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.projects.and.categories.none.selected"));
        }
    }

    private int validateDays(String days, Collection<ValidationError> errors) {
        try {
            int numberOfDays = Integer.valueOf(days);
            if (numberOfDays < 0) {
                errors.add(new ValidationError(DAYS, "gadget.common.negative.days"));
            } else if (numberOfDays > 1000) {
                errors.add(new ValidationError(DAYS, "gadget.common.days.overlimit", String.valueOf(1000)));
            }
            return numberOfDays;
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(DAYS, "gadget.common.days.nan"));
            return -1;
        }
    }

    private int validateNum(String num, Collection<ValidationError> errors) {
        try {
            int validatedNum = Integer.valueOf(num);
            if (validatedNum <= 0) {
                errors.add(new ValidationError(NUM, "gadget.common.num.negative"));
            } else if (validatedNum > 50) {
                errors.add(new ValidationError(NUM, "gadget.common.num.overlimit", String.valueOf(50)));
            }
            return validatedNum;
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(NUM, "gadget.common.num.nan"));
            return -1;
        }
    }

    @GET
    @Path(value="/generate")
    public Response generate(@QueryParam(value="projectsOrCategories") String projectsOrCategories, @QueryParam(value="days") @DefaultValue(value="30") int days, @QueryParam(value="num") @DefaultValue(value="10") int num) {
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        Set<Long> projectIds = this.getProjectIds(this.splitProjectAndCategoryIds(projectsOrCategories));
        DateTime periodEnd = DateTime.now().plusDays(days);
        List<Version> versions = this.getVersions(projectIds, periodEnd);
        if (versions.size() > num) {
            versions = versions.subList(0, num);
        }
        try {
            return Response.ok((Object)this.transform(versions, days, periodEnd)).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
        catch (SearchException se) {
            return Response.status((int)500).build();
        }
    }

    private String createIndexingUnavailableMessage() {
        String msg2;
        String msg1 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing");
        if (this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser())) {
            String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            msg2 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.configure", "<a href=\"" + baseUrl + "/secure/admin/jira/IndexAdmin.jspa\">", "</a>");
        } else {
            msg2 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.admin");
        }
        return msg1 + " " + msg2;
    }

    private List<String> splitProjectAndCategoryIds(String projectsOrCategories) {
        if (projectsOrCategories == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(projectsOrCategories.split("\\|"));
    }

    private RoadMapData transform(List<Version> source, int days, DateTime periodEnd) throws SearchException {
        ArrayList<VersionData> versions = new ArrayList<VersionData>(source.size());
        DateTimeFormatter dateFormatter = this.dateTimeFormatter.withStyle(DateTimeStyle.DATE);
        DateTimeFormatter outlookDate = this.dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE);
        for (Version version : source) {
            int unresolvedPercent;
            int resolvedPercent;
            Project srcProj = version.getProjectObject();
            ProjectData targetProj = new ProjectData(srcProj.getId(), srcProj.getKey(), srcProj.getName());
            Query allIssuesQuery = this.buildAllIssuesForFixVersionQuery(version);
            int all = (int)this.searchCount(allIssuesQuery);
            Query unresolvedIssuesQuery = this.buildUnresolvedIssuesForFixVersionQuery(version);
            int unresolved = (int)this.searchCount(unresolvedIssuesQuery);
            if (all == 0) {
                resolvedPercent = 100;
                unresolvedPercent = 0;
            } else {
                resolvedPercent = (all - unresolved) * 100 / all;
                unresolvedPercent = unresolved * 100 / all;
                int leftovers = 100 - (resolvedPercent + unresolvedPercent);
                if (resolvedPercent < unresolvedPercent) {
                    resolvedPercent += leftovers;
                } else {
                    unresolvedPercent += leftovers;
                }
            }
            ResolutionData resolvedData = new ResolutionData(all - unresolved, resolvedPercent, this.getQueryString(this.buildResolvedIssuesForFixVersionQuery(version)));
            ResolutionData unresolvedData = new ResolutionData(unresolved, unresolvedPercent, this.getQueryString(unresolvedIssuesQuery));
            VersionData ver = new VersionData(version.getId(), version.getName(), version.getDescription(), targetProj, dateFormatter.format(version.getReleaseDate()), outlookDate.format(version.getReleaseDate()), this.isOverdue(version), all, resolvedData, unresolvedData);
            versions.add(ver);
        }
        return new RoadMapData(versions, days, dateFormatter.format(periodEnd.toDate()));
    }

    public boolean isOverdue(Version version) {
        return new Date().compareTo(version.getReleaseDate()) > 0;
    }

    Set<Long> getProjectIds(List<String> projectAndCategoryIds) {
        if (CollectionUtils.isEmpty(projectAndCategoryIds)) {
            return Collections.emptySet();
        }
        if (projectAndCategoryIds.contains(ALL_PROJECTS)) {
            return this.getAllBrowsableProjects();
        }
        Set<Long> projectIds = RoadMapResource.filterProjectIds(projectAndCategoryIds);
        Set projectIds2 = RoadMapResource.filterProjectCategoryIds(projectAndCategoryIds).stream().flatMap(categoryId -> this.getProjectIdsForCategory((Long)categoryId).stream()).collect(Collectors.toSet());
        Collection union = CollectionUtils.union(projectIds, projectIds2);
        return union.stream().filter(id -> this.canBrowseProject((Long)id)).collect(Collectors.toSet());
    }

    private Set<Long> getAllBrowsableProjects() {
        ProjectPermissionKey permission = ProjectPermissions.BROWSE_PROJECTS;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return this.permissionManager.getProjects(permission, user).stream().map(p -> p.getId()).collect(Collectors.toSet());
    }

    boolean canBrowseProject(Long projectId) {
        Project project = this.projectManager.getProjectObj(projectId);
        return project != null && this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.authenticationContext.getLoggedInUser());
    }

    Set<Long> getProjectIdsForCategory(Long categoryId) {
        return this.projectManager.getProjectObjectsFromProjectCategory(categoryId).stream().map(p -> p.getId()).collect(Collectors.toSet());
    }

    List<Version> getVersions(Set<Long> projectIds, DateTime dateTime) {
        return projectIds.stream().flatMap(id -> this.getVersionsForProject((Long)id, dateTime.toDate()).stream()).sorted((v1, v2) -> v1.getReleaseDate().compareTo(v2.getReleaseDate())).collect(Collectors.toList());
    }

    Collection<Version> getVersionsForProject(Long projectId, Date releasedBefore) {
        Collection versions = this.versionManager.getVersionsUnreleased(projectId, false);
        ArrayList<Version> result = new ArrayList<Version>(versions.size());
        for (Version version : versions) {
            Date releaseDate = version.getReleaseDate();
            if (releaseDate == null || releaseDate.after(releasedBefore)) continue;
            result.add(version);
        }
        return result;
    }

    long searchCount(Query query) throws SearchException {
        return this.searchService.searchCount(this.authenticationContext.getLoggedInUser(), query);
    }

    Query buildAllIssuesForFixVersionQuery(Version version) {
        return JqlQueryBuilder.newBuilder().where().project(new String[]{version.getProjectObject().getName()}).and().fixVersion().eq(version.getName()).buildQuery();
    }

    Query buildUnresolvedIssuesForFixVersionQuery(Version version) {
        return JqlQueryBuilder.newBuilder().where().defaultAnd().project(new String[]{version.getProjectObject().getName()}).fixVersion().eq(version.getName()).resolution().isEmpty().buildQuery();
    }

    Query buildResolvedIssuesForFixVersionQuery(Version version) {
        return JqlQueryBuilder.newBuilder().where().defaultAnd().project(new String[]{version.getProjectObject().getName()}).fixVersion().eq(version.getName()).resolution().isNotEmpty().buildQuery();
    }

    String getQueryString(Query query) {
        if (query != null) {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            return this.searchService.getQueryString(user, query);
        }
        return null;
    }

    public static Set<Long> filterProjectIds(Collection<String> projectOrCategoryIds) {
        if (CollectionUtils.isEmpty(projectOrCategoryIds)) {
            return Collections.emptySet();
        }
        return projectOrCategoryIds.stream().filter(id -> !id.startsWith(CATEGORY)).filter(RoadMapResource::isLong).map(Long::valueOf).collect(Collectors.toSet());
    }

    public static Set<Long> filterProjectCategoryIds(Collection<String> projectOrCategoryIds) {
        if (CollectionUtils.isEmpty(projectOrCategoryIds)) {
            return Collections.emptySet();
        }
        return projectOrCategoryIds.stream().filter(id -> id.startsWith(CATEGORY)).map(id -> id.substring(CATEGORY.length())).filter(RoadMapResource::isLong).map(Long::valueOf).collect(Collectors.toSet());
    }

    private static boolean isLong(String s) {
        try {
            Long.valueOf(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @XmlRootElement
    public static class ProjectData {
        @XmlElement
        private long id;
        @XmlElement
        private String key;
        @XmlElement
        private String name;

        private ProjectData() {
        }

        ProjectData(long id, String key, String name) {
            this.id = id;
            this.key = key;
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }

    @XmlRootElement
    public static class ResolutionData {
        @XmlElement
        private int count;
        @XmlElement
        private int percentage;
        @XmlElement
        private String issueNavigatorUrl;

        private ResolutionData() {
        }

        ResolutionData(int count, int percentage, String jqlQuery) {
            this.count = count;
            this.percentage = percentage;
            this.issueNavigatorUrl = "/secure/IssueNavigator.jspa?reset=true" + jqlQuery;
        }

        public int getCount() {
            return this.count;
        }

        public int getPercentage() {
            return this.percentage;
        }

        public String getIssueNavigatorUrl() {
            return this.issueNavigatorUrl;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }

    @XmlRootElement
    public static class VersionData {
        @XmlElement
        private long id;
        @XmlElement
        private String name;
        @XmlElement
        private String description;
        @XmlElement
        private ProjectData owningProject;
        @XmlElement
        private String releaseDate;
        @XmlElement
        private String releaseDateIso8601;
        @XmlElement
        private boolean isOverdue;
        @XmlElement
        private int allCount;
        @XmlElement
        private ResolutionData resolved;
        @XmlElement
        private ResolutionData unresolved;

        private VersionData() {
        }

        VersionData(long id, String name, String description, ProjectData owningProject, String releaseDate, String releaseDateIso8601, boolean overdue, int allCount, ResolutionData resolved, ResolutionData unresolved) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.owningProject = owningProject;
            this.releaseDate = releaseDate;
            this.releaseDateIso8601 = releaseDateIso8601;
            this.isOverdue = overdue;
            this.allCount = allCount;
            this.resolved = resolved;
            this.unresolved = unresolved;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ProjectData getOwningProject() {
            return this.owningProject;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public String getReleaseDateIso8601() {
            return this.releaseDateIso8601;
        }

        public boolean isOverdue() {
            return this.isOverdue;
        }

        public int getAllCount() {
            return this.allCount;
        }

        public ResolutionData getResolved() {
            return this.resolved;
        }

        public ResolutionData getUnresolved() {
            return this.unresolved;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }

    @XmlRootElement
    public static class RoadMapData {
        @XmlElement
        private int days;
        @XmlElement
        private String dateBefore;
        @XmlElement
        private Collection<VersionData> versions;

        private RoadMapData() {
        }

        public RoadMapData(Collection<VersionData> versions, int days, String dateBefore) {
            this.versions = versions;
            this.days = days;
            this.dateBefore = dateBefore;
        }

        public int getDays() {
            return this.days;
        }

        public String getDateBefore() {
            return this.dateBefore;
        }

        public Collection<VersionData> getVersions() {
            return Collections.unmodifiableCollection(this.versions);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }
}

