/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.TimeChart;
import com.atlassian.jira.gadgets.system.util.ResourceDateValidator;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.TimeSeriesCollection;

@Path(value="resolutiontime")
@AnonymousAllowed
@Produces(value={"application/json"})
public class ResolutionTimeResource
extends SearchQueryBackedResource {
    static final String DAYS = "daysprevious";
    static final String PERIOD_NAME = "periodName";
    private static final String SEARCH_QUERY = "projectOrFilterId";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String INLINE = "inline";
    private static final String RETURN_DATA = "returnData";
    private final ChartFactory chartFactory;
    private static final String LABEL_SUFFIX_KEY = "datacollector.daystoresolve";
    private final ResourceDateValidator resourceDateValidator;
    private final TimeZoneManager timeZoneManager;

    public ResolutionTimeResource(@ComponentImport ChartFactory chartFactory, @ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchService searchService, @ComponentImport PermissionManager permissionManager, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport TimeZoneManager timeZoneManager) {
        this(chartUtils, authenticationContext, searchService, permissionManager, chartFactory, new ResourceDateValidator(applicationProperties), velocityRequestContextFactory, timeZoneManager);
    }

    ResolutionTimeResource(ChartUtils chartUtils, JiraAuthenticationContext authenticationContext, SearchService searchService, PermissionManager permissionManager, ChartFactory chartFactory, ResourceDateValidator resourceDateValidator, VelocityRequestContextFactory velocityRequestContextFactory, TimeZoneManager timeZoneManager) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.chartFactory = chartFactory;
        this.resourceDateValidator = resourceDateValidator;
        this.timeZoneManager = timeZoneManager;
    }

    @GET
    @Path(value="/generate")
    public Response getChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName, @QueryParam(value="returnData") @DefaultValue(value="false") boolean returnData, @QueryParam(value="width") @DefaultValue(value="450") int width, @QueryParam(value="height") @DefaultValue(value="300") int height, @QueryParam(value="inline") @DefaultValue(value="false") boolean inline) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        int daysInt = this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        try {
            Chart chart = this.generateChart(width, height, user, searchRequest, period, daysInt, inline);
            TimeChart.TimeDataRow[] data = returnData ? this.getData(new TimeChart.Generator(), chart) : null;
            TimeChart resolutionTimeChart = this.createChart(width, height, params, chart, data);
            return Response.ok((Object)resolutionTimeChart).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    Chart generateChart(int width, int height, ApplicationUser user, SearchRequest searchRequest, ChartFactory.PeriodName period, int daysInt, boolean inline) {
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(user, searchRequest, width, height, inline);
        return this.chartFactory.generateDateRangeTimeChart(context, daysInt, period, DateUtils.DAY_MILLIS, LABEL_SUFFIX_KEY, "resolutiondate");
    }

    TimeChart createChart(int width, int height, Map<String, Object> params, Chart chart, TimeChart.TimeDataRow[] data) {
        String location = chart.getLocation();
        String title = this.getFilterTitle(params);
        String filterUrl = this.getFilterUrl(params);
        String imageMap = chart.getImageMap();
        String imageMapName = chart.getImageMapName();
        return new TimeChart(location, title, filterUrl, imageMap, imageMapName, data, width, height, chart.getBase64Image());
    }

    TimeChart.TimeDataRow[] getData(TimeChart.Generator generator, Chart chart) {
        Map params = chart.getParameters();
        TimeSeriesCollection dataSet = (TimeSeriesCollection)params.get("completeDataset");
        XYURLGenerator urlGenerator = (XYURLGenerator)params.get("completeDatasetUrlGenerator");
        return generator.generateDataSet(dataSet, urlGenerator, this.timeZoneManager);
    }

    @GET
    @Path(value="validate")
    public Response validate(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(queryString, errors, new HashMap<String, Object>());
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        return this.createValidationResponse(errors);
    }
}

