/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.util.ResourceDateValidator;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;

@Path(value="/recentlyCreated")
@AnonymousAllowed
@Produces(value={"application/json"})
public class RecentlyCreatedChartResource
extends SearchQueryBackedResource {
    private static final String PERIOD_NAME = "periodName";
    private static final String DAYS = "daysprevious";
    private static final String NUM_ISSUES = "numIssues";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String INLINE = "inline";
    private final ChartFactory chartFactory;
    private static final String RETURN_DATA = "returnData";
    private ResourceDateValidator resourceDateValidator;

    public RecentlyCreatedChartResource(@ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchService searchService, @ComponentImport PermissionManager permissionManager, @ComponentImport ChartFactory chartFactory, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport ApplicationProperties applicationProperties) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.chartFactory = chartFactory;
        this.resourceDateValidator = new ResourceDateValidator(applicationProperties);
    }

    @GET
    @Path(value="/generate")
    public Response generateChart(@Context HttpServletRequest request, @QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName, @QueryParam(value="returnData") @DefaultValue(value="false") boolean returnData, @QueryParam(value="width") @DefaultValue(value="400") int width, @QueryParam(value="height") @DefaultValue(value="250") int height, @QueryParam(value="inline") @DefaultValue(value="false") boolean inline) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        int validatedDays = this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(user, searchRequest, width, height, inline);
        try {
            Chart chart = this.chartFactory.generateRecentlyCreated(context, validatedDays, period);
            String location = chart.getLocation();
            String title = this.getFilterTitle(params);
            String filterUrl = this.getFilterUrl(params);
            Integer issueCount = (Integer)chart.getParameters().get(NUM_ISSUES);
            String imageMap = chart.getImageMap();
            String imageMapName = chart.getImageMapName();
            Integer imageHeight = (Integer)chart.getParameters().get(HEIGHT);
            Integer imageWidth = (Integer)chart.getParameters().get(WIDTH);
            DataRow[] data = null;
            if (returnData) {
                CategoryDataset completeDataset = (CategoryDataset)chart.getParameters().get("completeDataset");
                CategoryURLGenerator completeUrlGenerator = (CategoryURLGenerator)chart.getParameters().get("completeDatasetUrlGenerator");
                data = this.generateDataset(completeDataset, completeUrlGenerator);
            }
            RecentlyCreatedChart recentlyCreatedChart = new RecentlyCreatedChart(location, title, filterUrl, imageMap, imageMapName, issueCount, imageWidth, imageHeight, data, chart.getBase64Image());
            return Response.ok((Object)recentlyCreatedChart).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    private DataRow[] generateDataset(CategoryDataset dataset, CategoryURLGenerator urlGenerator) {
        DataRow[] data = new DataRow[dataset.getColumnCount()];
        for (int col = 0; col < dataset.getColumnCount(); ++col) {
            Comparable key = dataset.getColumnKey(col);
            int unresolvedVal = dataset.getValue(0, col).intValue();
            String unresolvedUrl = urlGenerator.generateURL(dataset, 0, col);
            int resolvedVal = dataset.getValue(1, col).intValue();
            String resolvedUrl = urlGenerator.generateURL(dataset, 1, col);
            int totalCreatedVal = unresolvedVal + resolvedVal;
            data[col] = new DataRow(key, totalCreatedVal, resolvedVal, resolvedUrl, unresolvedVal, unresolvedUrl);
        }
        return data;
    }

    @GET
    @Path(value="/validate")
    public Response validateChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(queryString, errors, new HashMap<String, Object>());
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        return this.createValidationResponse(errors);
    }

    @XmlRootElement
    @XmlType(namespace="com.atlassian.jira.gadgets.system.RecentlyCreatedChartResource")
    public static class DataRow {
        private Object key;
        @XmlElement
        private int createdValue;
        @XmlElement
        private int resolvedValue;
        @XmlElement
        private String resolvedUrl;
        @XmlElement
        private int unresolvedValue;
        @XmlElement
        private String unresolvedUrl;
        @XmlElement(name="key")
        private String keyString;

        public DataRow() {
        }

        public DataRow(Object key, int createdValue, int resolvedValue, String resolvedUrl, int unresolvedValue, String unresolvedUrl) {
            this.key = key;
            this.createdValue = createdValue;
            this.resolvedValue = resolvedValue;
            this.resolvedUrl = resolvedUrl;
            this.unresolvedValue = unresolvedValue;
            this.unresolvedUrl = unresolvedUrl;
            this.keyString = key.toString();
        }

        public String getKey() {
            return this.key.toString();
        }

        public Object getRawKey() {
            return this.key;
        }

        public int getCreatedValue() {
            return this.createdValue;
        }

        public int getResolvedValue() {
            return this.resolvedValue;
        }

        public String getResolvedUrl() {
            return this.resolvedUrl;
        }

        public int getUnresolvedValue() {
            return this.unresolvedValue;
        }

        public String getUnresolvedUrl() {
            return this.unresolvedUrl;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    @XmlRootElement
    public static class RecentlyCreatedChart {
        @XmlElement
        private String location;
        @XmlElement
        private String filterTitle;
        @XmlElement
        private String filterUrl;
        @XmlElement
        private String imageMap;
        @XmlElement
        private String imageMapName;
        @XmlElement
        private Integer issueCount;
        @XmlElement
        private DataRow[] data;
        @XmlElement
        private Integer height;
        @XmlElement
        private Integer width;
        @XmlElement
        private String base64Image;

        RecentlyCreatedChart() {
        }

        RecentlyCreatedChart(String location, String filterTitle, String filterUrl, String imageMap, String imageMapName, Integer issueCount, Integer width, Integer height, DataRow[] data, String base64Image) {
            this.location = location;
            this.filterTitle = filterTitle;
            this.filterUrl = filterUrl;
            this.imageMap = imageMap;
            this.imageMapName = imageMapName;
            this.issueCount = issueCount;
            this.height = height;
            this.width = width;
            this.data = data;
            this.base64Image = base64Image;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFilterTitle() {
            return this.filterTitle;
        }

        public String getFilterUrl() {
            return this.filterUrl;
        }

        public String getImageMap() {
            return this.imageMap;
        }

        public String getImageMapName() {
            return this.imageMapName;
        }

        public Integer getIssueCount() {
            return this.issueCount;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public DataRow[] getData() {
            return this.data;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

