/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/projectsAndProjectCategories")
@AnonymousAllowed
@Produces(value={"application/json"})
public class ProjectsAndProjectCategoriesResource {
    private static final Logger log = LoggerFactory.getLogger(ProjectsAndProjectCategoriesResource.class);
    private static final ToStringStyle TO_STRING_STYLE = ToStringStyle.SIMPLE_STYLE;
    public static final String ALL_PROJECTS = "allprojects";
    public static final String ALL_CATEGORIES = "catallCategories";
    static final String CATEGORY = "cat";
    private JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public ProjectsAndProjectCategoriesResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @GET
    public Response generate() {
        ApplicationUser user = this.authenticationContext.getUser();
        Collection<Project> projects = this.getProjects(user);
        List<Option> projectOptions = this.getProjectOptions(user, projects);
        List<Option> categories = this.getCategoriesForProjects(projects);
        return Response.ok((Object)new ProjectAndCategories(categories, projectOptions)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public static Set<Long> filterProjectIds(Collection<String> projectOrCategoryIds) {
        HashSet<Long> projectIds = new HashSet<Long>();
        if (projectOrCategoryIds != null && !projectOrCategoryIds.isEmpty()) {
            for (String id : projectOrCategoryIds) {
                if (id.startsWith(CATEGORY)) continue;
                try {
                    Long projectId = new Long(id);
                    projectIds.add(projectId);
                }
                catch (NumberFormatException e) {
                    log.info("Project ID '" + id + "' could not be parsed!");
                }
            }
        }
        return projectIds;
    }

    public static Set<Long> filterProjectCategoryIds(Collection<String> projectOrCategoryIds) {
        HashSet<Long> categoryIds = new HashSet<Long>();
        if (projectOrCategoryIds != null && !projectOrCategoryIds.isEmpty()) {
            for (String id : projectOrCategoryIds) {
                if (!id.startsWith(CATEGORY)) continue;
                try {
                    Long categoryId = new Long(id.substring(CATEGORY.length()));
                    categoryIds.add(categoryId);
                }
                catch (NumberFormatException e) {
                    log.warn("Project Category ID '" + id + "' could not be parsed!");
                }
            }
        }
        return categoryIds;
    }

    private List<Option> getProjectOptions(ApplicationUser user, Collection<Project> projects) {
        ArrayList<Option> projectOptions = new ArrayList<Option>(projects.size());
        for (Project project : projects) {
            projectOptions.add(new Option(project.getName(), project.getId().toString()));
        }
        return projectOptions;
    }

    private Collection<Project> getProjects(ApplicationUser user) {
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
    }

    private List<Option> getCategoriesForProjects(Collection<Project> projects) {
        HashSet<Option> categoryOptionsSet = new HashSet<Option>();
        if (projects != null && !projects.isEmpty()) {
            for (Project project : projects) {
                ProjectCategory category = project.getProjectCategoryObject();
                if (category == null) continue;
                categoryOptionsSet.add(new Option(category.getName(), CATEGORY + category.getId()));
            }
        }
        ArrayList<Option> categoryOptions = new ArrayList<Option>(categoryOptionsSet);
        Collections.sort(categoryOptions, new Comparator<Option>(){

            @Override
            public int compare(Option option, Option option1) {
                return option.getLabel().compareTo(option1.getLabel());
            }
        });
        return categoryOptions;
    }

    @XmlType(namespace="com.atlassian.jira.gadgets.system.ProjectsAndProjectCategoriesResource")
    @XmlRootElement
    public static class Option {
        @XmlElement
        private String label;
        @XmlElement
        private String value;

        public Option() {
        }

        Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }

    @XmlType(namespace="com.atlassian.jira.gadgets.system.ProjectsAndProjectCategoriesResource")
    @XmlRootElement
    public static class ProjectAndCategories {
        @XmlElement
        private Collection<Option> categories;
        @XmlElement
        private Collection<Option> projects;

        public ProjectAndCategories() {
        }

        public ProjectAndCategories(Collection<Option> categories, Collection<Option> projects) {
            this.categories = categories;
            this.projects = projects;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }
}

