/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.search.SearchParseException;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pickers")
@Produces(value={"application/json"})
@AnonymousAllowed
public class PickerResource {
    private static final String DELIMS = "-_/\\,+=&^%$#*@!~`'\":;<> ";
    private static final int FILTER_RESULTS_SIZE = 10;
    private static final String LUCENE_WILDCARDS_PATTERN = "^[?*]+$";
    private static final Logger log = LoggerFactory.getLogger(PickerResource.class);
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestManager searchRequestManager;

    public PickerResource(@ComponentImport PermissionManager permissionManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchRequestManager searchRequestManager) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.searchRequestManager = searchRequestManager;
    }

    @Path(value="projectsAndFilters")
    @GET
    public Response searchForProjectsAndCategories(@QueryParam(value="query") @DefaultValue(value="") String query) {
        if (query.startsWith("*") || query.startsWith("?")) {
            ErrorCollection errorCollection = ErrorCollection.Builder.newBuilder((ValidationError[])new ValidationError[]{new ValidationError("quickfind", "gadget.common.invalid.projectOrFilterId.query.prefix")}).build();
            return Response.status((int)400).entity((Object)errorCollection).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)this.projectAndFilters(query)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public ProjectsAndFiltersWrapper projectAndFilters(String query) {
        ProjectPickerWrapper projects = this.getProjects(query);
        FilterPickerWrapper filters = this.getFilters(query);
        return new ProjectsAndFiltersWrapper(projects.projects, filters.filters);
    }

    @Path(value="projects")
    @GET
    public Response searchForProjects(@QueryParam(value="query") @DefaultValue(value="") String query) {
        if (query.startsWith("*") || query.startsWith("?")) {
            ErrorCollection errorCollection = ErrorCollection.Builder.newBuilder((ValidationError[])new ValidationError[]{new ValidationError("quickfind", "gadget.common.invalid.projectOrFilterId.query.prefix")}).build();
            return Response.status((int)400).entity((Object)errorCollection).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)this.getProjects(query)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public ProjectPickerWrapper getProjects(String query) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getUser());
        ProjectPickerWrapper result = new ProjectPickerWrapper();
        for (Project project : projects) {
            if (!this.projectMatches(project, query)) continue;
            result.addProject(new ProjectPickerBean(project.getId().toString(), this.formatProject(project, query), project.getName(), project.getKey()));
        }
        return result;
    }

    @Path(value="filters")
    @GET
    public Response searchForFilters(@QueryParam(value="query") @DefaultValue(value="") String query) {
        return Response.ok((Object)this.getFilters(query)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public FilterPickerWrapper getFilters(String query) {
        List<SearchRequest> exactMatch = this.queryLuceneForExactMatch(query);
        List<SearchRequest> suggestedFilters = this.queryLuceneForFiltersSuggestions(query);
        List<SearchRequest> searchResults = this.mergeOptionalExactMatchWithSuggestions(exactMatch, suggestedFilters);
        FilterPickerWrapper filterPickerWrapper = new FilterPickerWrapper();
        for (SearchRequest searchRequest : searchResults) {
            filterPickerWrapper.addFilter(new FilterPickerBean(searchRequest.getId().toString(), searchRequest.getName(), this.formatField(searchRequest.getName(), query), this.formatField(searchRequest.getDescription(), query)));
        }
        return filterPickerWrapper;
    }

    private List<SearchRequest> queryLuceneForExactMatch(String fullFilterName) {
        SharedEntitySearchParameters params = this.getFilterSearchParameters(fullFilterName, SharedEntitySearchParameters.TextSearchMode.EXACT);
        return this.searchRequestManager.search(params, this.authenticationContext.getLoggedInUser(), 0, 1).getResults();
    }

    private String escapeLuceneOperatorsForSuggestionsQuery(String query) {
        return QueryParser.escape((String)query);
    }

    private List<SearchRequest> queryLuceneForFiltersSuggestions(String query) {
        Pattern pattern = Pattern.compile(LUCENE_WILDCARDS_PATTERN);
        Matcher matcher = pattern.matcher(query);
        if (matcher.matches()) {
            return Collections.emptyList();
        }
        String escapedQuery = this.escapeLuceneOperatorsForSuggestionsQuery(query);
        SharedEntitySearchParameters wildcardParams = this.getFilterSearchParameters(escapedQuery, SharedEntitySearchParameters.TextSearchMode.WILDCARD);
        try {
            return this.searchRequestManager.search(wildcardParams, this.authenticationContext.getLoggedInUser(), 0, 10).getResults();
        }
        catch (SearchParseException e) {
            log.error("Search query " + query + " resulted in the following error", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private SharedEntitySearchParameters getFilterSearchParameters(String query, SharedEntitySearchParameters.TextSearchMode searchMode) {
        SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder();
        builder.setSortColumn(SharedEntityColumn.NAME, true);
        builder.setEntitySearchContext(SharedEntitySearchContext.USE);
        builder.setTextSearchMode(searchMode);
        builder.setName(query);
        return builder.toSearchParameters();
    }

    private List<SearchRequest> mergeOptionalExactMatchWithSuggestions(List<SearchRequest> exactMatch, List<SearchRequest> suggestedFilters) {
        List suggestionsWithoutExactMatch = ListUtils.removeAll(suggestedFilters, exactMatch);
        ImmutableList mergedResults = new ImmutableList.Builder().addAll(exactMatch).addAll((Iterable)suggestionsWithoutExactMatch).build();
        if (mergedResults.size() > 10) {
            return mergedResults.subList(0, 10);
        }
        return mergedResults;
    }

    private boolean projectMatches(Project project, String query) {
        query = query.toLowerCase().trim();
        String projectName = project.getName().toLowerCase();
        String projectKey = project.getKey().toLowerCase();
        if (projectName.startsWith(query) || projectKey.startsWith(query)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(project.getName().toLowerCase(), DELIMS);
        while (tokenizer.hasMoreElements()) {
            String projPart = tokenizer.nextToken();
            if (!projPart.startsWith(query)) continue;
            return true;
        }
        return false;
    }

    private String formatProject(Project project, String query) {
        String projectName = this.formatField(project.getName(), query);
        String projectKey = this.formatField(project.getKey(), query);
        StringBuilder sb = new StringBuilder();
        sb.append(projectName);
        sb.append("&nbsp;(");
        sb.append(projectKey);
        sb.append(")");
        return sb.toString();
    }

    private String formatField(String field, String query) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<strong>", "</strong>");
        delimeterInserter.setConsideredWhitespace(DELIMS);
        StringTokenizer tokenizer = new StringTokenizer(query, DELIMS);
        ArrayList<String> terms = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String projPart = tokenizer.nextToken();
            if (!StringUtils.isNotBlank((String)projPart)) continue;
            terms.add(projPart);
        }
        return delimeterInserter.insert(TextUtils.htmlEncode((String)field), terms.toArray(new String[terms.size()]));
    }

    @XmlRootElement
    public static class FilterPickerBean {
        @XmlElement
        private String id;
        @XmlElement
        private String name;
        @XmlElement
        private String nameHtml;
        @XmlElement
        private String descHtml;

        private FilterPickerBean() {
        }

        public FilterPickerBean(String id, String name, String nameHtml, String descHtml) {
            this.id = id;
            this.name = name;
            this.nameHtml = nameHtml;
            this.descHtml = descHtml;
        }
    }

    @XmlRootElement
    public static class FilterPickerWrapper {
        @XmlElement
        private List<FilterPickerBean> filters;

        private FilterPickerWrapper() {
        }

        private FilterPickerWrapper(List<FilterPickerBean> filters) {
            this.filters = filters;
        }

        public void addFilter(FilterPickerBean filter) {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterPickerBean>();
            }
            this.filters.add(filter);
        }
    }

    @XmlRootElement
    public static class ProjectPickerBean {
        @XmlElement
        private String html;
        @XmlElement
        private String name;
        @XmlElement
        private String key;
        @XmlElement
        private String id;

        private ProjectPickerBean() {
        }

        private ProjectPickerBean(String id, String html, String name, String key) {
            this.html = html;
            this.name = name;
            this.key = key;
            this.id = id;
        }
    }

    @XmlRootElement
    public static class ProjectPickerWrapper {
        @XmlElement
        private List<ProjectPickerBean> projects;

        private ProjectPickerWrapper() {
        }

        private ProjectPickerWrapper(List<ProjectPickerBean> projects) {
            this.projects = projects;
        }

        public void addProject(ProjectPickerBean project) {
            if (this.projects == null) {
                this.projects = new ArrayList<ProjectPickerBean>();
            }
            this.projects.add(project);
        }
    }

    @XmlRootElement
    public static class ProjectsAndFiltersWrapper {
        @XmlElement
        private List<ProjectPickerBean> projects;
        @XmlElement
        private List<FilterPickerBean> filters;

        public ProjectsAndFiltersWrapper() {
        }

        public ProjectsAndFiltersWrapper(List<ProjectPickerBean> projects, List<FilterPickerBean> filters) {
            this.projects = projects;
            this.filters = filters;
        }
    }
}

