/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringEscapeUtils;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.label.AlphabeticalLabelGroupingService;
import com.atlassian.jira.issue.label.AlphabeticalLabelGroupingSupport;
import com.atlassian.jira.issue.label.AlphabeticalLabelRenderer;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="labels")
@AnonymousAllowed
@Produces(value={"application/json"})
public class LabelsResource {
    private static final Logger log = LoggerFactory.getLogger(LabelsResource.class);
    private static final String PROJECT_ID_PREFIX = "project-";
    private final CustomFieldManager customFieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private AlphabeticalLabelRenderer alphabeticalLabelRenderer;
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final LabelUtil labelUtil;
    private AlphabeticalLabelGroupingService alphabeticalLabelGroupingService;

    public LabelsResource(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport AlphabeticalLabelRenderer alphabeticalLabelRenderer, @ComponentImport ProjectManager projectManager, @ComponentImport FieldManager fieldManager, @ComponentImport LabelUtil labelUtil, @ComponentImport AlphabeticalLabelGroupingService alphabeticalLabelGroupingService) {
        this.customFieldManager = customFieldManager;
        this.authenticationContext = authenticationContext;
        this.alphabeticalLabelRenderer = alphabeticalLabelRenderer;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.labelUtil = labelUtil;
        this.alphabeticalLabelGroupingService = alphabeticalLabelGroupingService;
    }

    @GET
    @Path(value="gadget/fields")
    @Produces(value={"application/json"})
    public Response getLabelFields() {
        Collection labelCfTypes = CollectionUtil.filter((Collection)this.customFieldManager.getCustomFieldObjects(), (Predicate)new Predicate<CustomField>(){

            public boolean evaluate(CustomField input) {
                return input.getCustomFieldType() instanceof LabelsCFType;
            }
        });
        ArrayList<LabelField> labelFields = new ArrayList<LabelField>(labelCfTypes.size() + 1);
        labelFields.add(new LabelField(this.authenticationContext.getI18nHelper().getText("issue.field.labels"), "labels"));
        for (CustomField labelCf : labelCfTypes) {
            LabelField labelField = new LabelField(labelCf.getName(), labelCf.getId());
            labelFields.add(labelField);
        }
        return Response.ok((Object)new LabelFields(labelFields)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="gadget/configuration/validate")
    @Produces(value={"application/json"})
    public Response validateLabelGadgetConfiguration() {
        return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="gadget/{project}/{fieldId}/groups")
    @Produces(value={"text/html"})
    public Response getLabelGroups(@PathParam(value="project") String project, @PathParam(value="fieldId") String fieldId) {
        Optional<Long> projectId = this.parseProjectId(project);
        if (!projectId.isPresent()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error parsing project id from '" + StringEscapeUtils.escapeHtml((String)project) + "'")).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)this.alphabeticalLabelRenderer.getHtml(this.authenticationContext.getLoggedInUser(), projectId.get(), fieldId, true)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="gadget/{project}/{fieldId}")
    @Produces(value={"application/json"})
    public Response getLabelsGroupsJSON(@PathParam(value="project") String project, @PathParam(value="fieldId") String fieldId) {
        Optional<Long> projectId = this.parseProjectId(project);
        if (!projectId.isPresent()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error parsing project id from '" + StringEscapeUtils.escapeHtml((String)project) + "'")).cacheControl(CacheControl.NO_CACHE).build();
        }
        Optional<Field> field = Optional.ofNullable(this.fieldManager.getField(fieldId));
        Optional<Project> projectObj = Optional.ofNullable(this.projectManager.getProjectObj(projectId.get()));
        if (!field.isPresent() || !projectObj.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        AlphabeticalLabelGroupingSupport alphaSupport = this.alphabeticalLabelGroupingService.getAlphabeticallyGroupedLabels(this.authenticationContext.getLoggedInUser(), projectId.get(), fieldId);
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ArrayList groups = Lists.newArrayList();
        for (String key : alphaSupport.getKeys()) {
            Set labels = alphaSupport.getContents(key);
            ArrayList elements = Lists.newArrayList();
            for (String label : labels) {
                String issueSearchUrl = fieldId.startsWith("customfield_") ? this.labelUtil.getLabelSearchPathForProject(user, projectId.get(), CustomFieldUtils.getCustomFieldId((String)fieldId), label) : this.labelUtil.getLabelSearchPathForProject(user, projectId.get(), label);
                elements.add(new LabelElement(label, issueSearchUrl));
            }
            groups.add(new LabelGroup(key, elements));
        }
        LabelGroupList labelGroups = new LabelGroupList(field.get().getName(), projectObj.get().getName(), groups);
        return Response.ok((Object)labelGroups).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Optional<Long> parseProjectId(String project) {
        try {
            return Optional.of(Long.parseLong(StringUtils.substring((String)project, (int)PROJECT_ID_PREFIX.length())));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @XmlRootElement
    public static class LabelGroupList {
        @XmlElement
        private final List<LabelGroup> groups;
        @XmlElement
        private final String field;
        @XmlElement
        private final String project;

        public LabelGroupList(String field, String project, List<LabelGroup> groups) {
            this.field = field;
            this.project = project;
            this.groups = groups;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelGroupList that = (LabelGroupList)o;
            return Objects.equals(this.groups, that.groups) && Objects.equals(this.field, that.field) && Objects.equals(this.project, that.project);
        }

        public int hashCode() {
            return Objects.hash(this.groups, this.field, this.project);
        }
    }

    @XmlRootElement
    public static class LabelGroup {
        @XmlElement
        private final String key;
        @XmlElement
        private final List<LabelElement> labels;

        public LabelGroup(String key, List<LabelElement> labels) {
            this.key = key;
            this.labels = labels;
        }

        public String getKey() {
            return this.key;
        }

        public List<LabelElement> getLabels() {
            return this.labels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelGroup that = (LabelGroup)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.labels, that.labels);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.labels);
        }
    }

    @XmlRootElement
    public static class LabelElement {
        @XmlElement
        private final String label;
        @XmlElement
        private final String searchUrl;

        public LabelElement(String label, String searchUrl) {
            this.label = label;
            this.searchUrl = searchUrl;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSearchUrl() {
            return this.searchUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelElement that = (LabelElement)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.searchUrl, that.searchUrl);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.searchUrl);
        }
    }

    @XmlRootElement
    public static class LabelFields {
        @XmlElement
        private final List<LabelField> labelFields = new ArrayList<LabelField>();

        private LabelFields() {
        }

        public LabelFields(List<LabelField> labelFields) {
            this.labelFields.addAll(labelFields);
        }
    }

    @XmlRootElement
    public static class LabelField {
        @XmlElement
        private String label;
        @XmlElement
        private String value;

        private LabelField() {
        }

        public LabelField(String label, String value) {
            this.label = label;
            this.value = value;
        }
    }
}

