/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.gadgets.system.AbstractResource;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.log.OneShotLogger;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssuePager;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.component.TableLayoutUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/issueTable")
@AnonymousAllowed
@Produces(value={"application/json"})
public class IssueTableResource
extends AbstractResource {
    private static final Logger log = Logger.getLogger(IssueTableResource.class);
    private static final int MERGE_SORT_CLAUSES_LIMIT = 100;
    private static OneShotLogger maxRowsLogger = new OneShotLogger(log);
    private static final String DEFAULT_NUM_TO_SHOW = "5";
    private static final int DEFAULT_MAX_ROWS = 50;
    private static final String REST_CONTEXT_PATH = "/rest/gadget/1.0";
    private static final String FILTER_ID = "filterId";
    private static final String JQL = "jql";
    protected static final String PROJECT_ID = "projectId";
    private static final String FILTER_PREFIX = "filter-";
    private static final String PROJECT_PREFIX = "project-";
    private static final String JQL_PREFIX = "jql-";
    static final String NUM_FIELD = "num";
    private static final String TABLE_CONTEXT = "tableContext";
    static final String COLUMN_NAMES = "columnNames";
    private static final String SORT_BY = "sortBy";
    private static final String PAGING = "paging";
    private static final String START_INDEX = "startIndex";
    private static final String ENABLE_SORTING = "enableSorting";
    private static final String DISPLAY_HEADER = "displayHeader";
    private static final String SHOW_ACTIONS = "showActions";
    private static final String COMPLETED = "completed";
    private static final String TITLE = "title";
    private static final String ADD_DEFAULTS = "addDefault";
    private static final String USE_CONFIGURED_COLS = "useConfiguredCols";
    private final JiraAuthenticationContext authenticationContext;
    private final SearchService searchService;
    private final SearchProvider searchProvider;
    private final TableLayoutUtils tableLayoutUtils;
    private final SearchRequestService searchRequestService;
    private final FieldManager fieldManager;
    private final SearchSortUtil searchSortUtil;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final VersionManager versionManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final ColumnLayoutManager columnLayoutManager;
    private final JqlStringSupport jqlStringSupport;

    public IssueTableResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchService searchService, @ComponentImport SearchProvider searchProvider, @ComponentImport TableLayoutUtils tableLayoutUtils, @ComponentImport SearchRequestService searchRequestService, @ComponentImport FieldManager fieldManager, @ComponentImport SearchSortUtil searchSortUtil, @ComponentImport ProjectManager projectManager, @ComponentImport PermissionManager permissionManager, @ComponentImport VersionManager versionManager, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport ColumnLayoutManager columnLayoutManager, @ComponentImport JqlStringSupport jqlStringSupport) {
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.searchProvider = searchProvider;
        this.tableLayoutUtils = tableLayoutUtils;
        this.searchRequestService = searchRequestService;
        this.fieldManager = fieldManager;
        this.searchSortUtil = searchSortUtil;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.versionManager = versionManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.columnLayoutManager = columnLayoutManager;
        this.jqlStringSupport = jqlStringSupport;
    }

    @GET
    @Path(value="filter/validate")
    public Response validateFilterTable(@QueryParam(value="filterId") String filterId, @QueryParam(value="columnNames") List<String> columnNames, @QueryParam(value="num") String numberToShow) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(filterId, errors);
        this.validateColumnNames(columnNames, errors);
        this.validateNumberToShow(NUM_FIELD, numberToShow, errors);
        return this.createValidationResponse(errors);
    }

    @GET
    @Path(value="filter")
    public Response getFilterTable(@Context HttpServletRequest request, @QueryParam(value="tableContext") String context, @QueryParam(value="filterId") String filterId, @QueryParam(value="columnNames") List<String> columnNames, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="paging") @DefaultValue(value="false") boolean isPaging, @QueryParam(value="startIndex") @DefaultValue(value="0") int start, @QueryParam(value="num") @DefaultValue(value="5") String numberToShow, @QueryParam(value="enableSorting") @DefaultValue(value="false") boolean enableSorting, @QueryParam(value="displayHeader") @DefaultValue(value="true") boolean displayHeader, @QueryParam(value="showActions") @DefaultValue(value="false") boolean showActions, @QueryParam(value="addDefault") @DefaultValue(value="false") boolean addDefaults) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(filterId, errors);
        if (StringUtils.isBlank((String)numberToShow)) {
            numberToShow = DEFAULT_NUM_TO_SHOW;
        }
        int validatedNumberToShow = this.validateNumberToShow(NUM_FIELD, numberToShow, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        this.addOrderByToSearchRequest(searchRequest, sortBy);
        LinkedLabelledQuery linkedLabelledQuery = new LinkedLabelledQuery(searchRequest);
        List<ColumnLayoutItem> columns = this.getColumns(context, columnNames, addDefaults, false);
        return this.createResponse(request, linkedLabelledQuery, columns, isPaging, start, validatedNumberToShow, enableSorting, displayHeader, showActions, null);
    }

    @GET
    @Path(value="jql/validate")
    public Response validateJql(@QueryParam(value="num") String numberToShow, @QueryParam(value="columnNames") List<String> columnNames) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateColumnNames(columnNames, errors);
        this.validateNumberToShow(NUM_FIELD, numberToShow, errors);
        return this.createValidationResponse(errors);
    }

    @GET
    @Path(value="jql")
    public Response getJqlTable(@Context HttpServletRequest request, @QueryParam(value="tableContext") String context, @QueryParam(value="jql") String jql, @QueryParam(value="title") String title, @QueryParam(value="columnNames") List<String> columnNames, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="paging") @DefaultValue(value="false") boolean isPaging, @QueryParam(value="startIndex") @DefaultValue(value="0") int start, @QueryParam(value="num") @DefaultValue(value="5") String numberToShow, @QueryParam(value="enableSorting") @DefaultValue(value="false") boolean enableSorting, @QueryParam(value="displayHeader") @DefaultValue(value="true") boolean displayHeader, @QueryParam(value="showActions") @DefaultValue(value="false") boolean showActions, @QueryParam(value="addDefault") @DefaultValue(value="false") boolean addDefaults, @QueryParam(value="useConfiguredCols") @DefaultValue(value="false") boolean useConfiguredCols) {
        SearchService.ParseResult parseResult;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        if (StringUtils.isBlank((String)numberToShow)) {
            numberToShow = DEFAULT_NUM_TO_SHOW;
        }
        if (!(parseResult = this.searchService.parseQuery(user, jql)).isValid()) {
            Set messageErrors = parseResult.getErrors().getErrorMessages();
            for (String messageError : messageErrors) {
                errors.add(new ValidationError(JQL, messageError));
            }
            if (errors.isEmpty()) {
                errors.add(new ValidationError(JQL, this.authenticationContext.getI18nHelper().getText("jql.parse.unknown.no.pos")));
            }
            return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder(errors).build()).cacheControl(CacheControl.NO_CACHE).build();
        }
        SearchRequest sr = new SearchRequest(parseResult.getQuery());
        this.addOrderByToSearchRequest(sr, sortBy);
        LinkedLabelledQuery query = new LinkedLabelledQuery(sr.getQuery(), title, null, jql);
        query.query = (Query)new QueryImpl(query.query.getWhereClause(), query.query.getOrderByClause(), null);
        int validatedNumberToShow = this.validateNumberToShow(NUM_FIELD, numberToShow, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        List<ColumnLayoutItem> columns = this.getColumns(context, columnNames, addDefaults, useConfiguredCols);
        Map<String, String> columnSortJql = this.generateColumnSortJql(sr, query, columns);
        return this.createResponse(request, query, columns, isPaging, start, validatedNumberToShow, enableSorting, displayHeader, showActions, columnSortJql);
    }

    public Map<String, String> generateColumnSortJql(SearchRequest sr, LinkedLabelledQuery query, List<ColumnLayoutItem> columns) {
        HashMap<String, String> columnSortJql = new HashMap<String, String>();
        for (ColumnLayoutItem column : columns) {
            String id = column.getId();
            OrderBy ob = this.buildOrderBy(sr.getQuery().getOrderByClause(), id);
            QueryImpl queryWithOrder = new QueryImpl(query.query.getWhereClause(), ob, null);
            columnSortJql.put(id, this.jqlStringSupport.generateJqlString((Query)queryWithOrder));
        }
        return columnSortJql;
    }

    private OrderBy buildOrderBy(OrderBy ob, String columnName) {
        SortOrder columnDirection = SortOrder.ASC;
        List searchSorts = ob.getSearchSorts();
        ArrayList<SearchSort> newSearchSortList = new ArrayList<SearchSort>(searchSorts.size() + 1);
        Iterator iterator = searchSorts.iterator();
        while (iterator.hasNext()) {
            SearchSort searchSort;
            SearchSort newSearchSort = searchSort = (SearchSort)iterator.next();
            if (searchSort.getField().equalsIgnoreCase(columnName)) {
                if (searchSort.getSortOrder() != SortOrder.ASC) continue;
                columnDirection = SortOrder.DESC;
                continue;
            }
            newSearchSortList.add(newSearchSort);
        }
        newSearchSortList.add(0, new SearchSort(columnName, columnDirection));
        return new OrderByImpl(newSearchSortList);
    }

    @GET
    @Path(value="iteration/validate")
    public Response validateIterationTable(@QueryParam(value="projectId") String projectId, @QueryParam(value="columnNames") List<String> columnNames, @QueryParam(value="num") String numberToShow) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidateForIteration(projectId, errors, true);
        this.validateColumnNames(columnNames, errors);
        this.validateNumberToShow(NUM_FIELD, numberToShow, errors);
        return this.createValidationResponse(errors);
    }

    @GET
    @Path(value="iteration")
    public Response getIterationTable(@Context HttpServletRequest request, @QueryParam(value="tableContext") String context, @QueryParam(value="projectId") String projectId, @QueryParam(value="completed") @DefaultValue(value="true") boolean completed, @QueryParam(value="columnNames") List<String> columnNames, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="paging") @DefaultValue(value="false") boolean isPaging, @QueryParam(value="startIndex") @DefaultValue(value="0") int start, @QueryParam(value="num") @DefaultValue(value="5") String numberToShow, @QueryParam(value="enableSorting") @DefaultValue(value="false") boolean enableSorting, @QueryParam(value="displayHeader") @DefaultValue(value="true") boolean displayHeader, @QueryParam(value="showActions") @DefaultValue(value="false") boolean showActions) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        SearchRequest searchRequest = this.getSearchRequestAndValidateForIteration(projectId, errors, completed);
        int validatedNumberToShow = this.validateNumberToShow(NUM_FIELD, numberToShow, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        this.addOrderByToSearchRequest(searchRequest, sortBy);
        LinkedLabelledQuery linkedLabelledQuery = new LinkedLabelledQuery(searchRequest);
        List<ColumnLayoutItem> columns = this.getColumns(context, columnNames, false, false);
        return this.createResponse(request, linkedLabelledQuery, columns, isPaging, start, validatedNumberToShow, enableSorting, displayHeader, showActions, null);
    }

    void addOrderByToSearchRequest(SearchRequest searchRequest, String sortBy) {
        if (StringUtils.isNotBlank((String)sortBy)) {
            String sortDirection = null;
            if (sortBy.endsWith(":DESC") || sortBy.endsWith(":ASC")) {
                sortDirection = sortBy.substring(sortBy.lastIndexOf(58) + 1);
                sortBy = sortBy.substring(0, sortBy.lastIndexOf(58));
            }
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
            String[] sortArray = new String[]{sortDirection};
            String[] fieldArray = new String[]{sortBy};
            MapBuilder builder = MapBuilder.newBuilder();
            Map params = builder.add((Object)"sorter/order", (Object)sortArray).add((Object)"sorter/field", (Object)fieldArray).toMap();
            OrderBy newOrder = this.searchSortUtil.getOrderByClause(params);
            OrderBy oldOrder = queryBuilder.orderBy().buildOrderBy();
            ApplicationUser user = this.authenticationContext.getUser();
            List newSearchSorts = newOrder.getSearchSorts();
            List oldSearchSorts = oldOrder.getSearchSorts();
            List sorts = this.searchSortUtil.mergeSearchSorts(user, (Collection)newSearchSorts, (Collection)oldSearchSorts, 100);
            queryBuilder.orderBy().setSorts((Collection)sorts);
            searchRequest.setQuery(queryBuilder.buildQuery());
        }
    }

    private String getURLFromSearchRequest(SearchRequest searchRequest) {
        ApplicationUser user = this.authenticationContext.getUser();
        if (searchRequest.isLoaded() && searchRequest.getId() != null) {
            return this.searchService.getIssueSearchPath(user, SearchService.IssueSearchParameters.builder().filterId(searchRequest.getId()).build());
        }
        Query query = searchRequest.getQuery();
        return this.searchService.getIssueSearchPath(user, SearchService.IssueSearchParameters.builder().query(query).build());
    }

    private IssueTableLayoutBean createLayout(LinkedLabelledQuery linkedLabelledQuery, List<ColumnLayoutItem> columns, boolean enableSorting, boolean displayHeader, boolean showActions) {
        OrderBy orderBy = linkedLabelledQuery.query.getOrderByClause();
        IssueTableLayoutBean layout = new IssueTableLayoutBean(columns, (Collection)orderBy.getSearchSorts());
        layout.setSortingEnabled(enableSorting);
        layout.setDisplayHeader(displayHeader);
        layout.setShowExteriorTable(false);
        layout.setShowActionColumn(showActions);
        layout.setTableCssClass("grid issuetable-db maxWidth");
        layout.setDisplayHeaderPager(false);
        return layout;
    }

    private IssueTable createIssueTable(SearchResults results, LinkedLabelledQuery linkedLabelledQuery, IssueTableLayoutBean layout, boolean isPaging, int numberToShow, Map<String, String> columnSortJql) {
        String html = results.getIssues().isEmpty() ? null : new IssueTableWebComponent().getHtml(layout, results.getIssues(), (IssuePager)(isPaging ? results : null));
        String url = linkedLabelledQuery.link;
        String name = linkedLabelledQuery.title;
        String description = linkedLabelledQuery.description;
        return new IssueTable(html, results.getIssues().size(), results.getTotal(), results.getNiceStart(), results.getEnd(), 0, numberToShow, url, name, description, columnSortJql);
    }

    Response createResponse(HttpServletRequest request, LinkedLabelledQuery linkedLabelledQuery, List<ColumnLayoutItem> columns, boolean isPaging, int start, int numberToShow, boolean enableSorting, boolean displayHeader, boolean showActions, Map<String, String> columnSortJql) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        if (columns == null || columns.isEmpty()) {
            errors.add(new ValidationError(COLUMN_NAMES, "gadget.issuetable.common.no.columns"));
            return this.createErrorResponse(errors);
        }
        IssueTableLayoutBean layout = this.createLayout(linkedLabelledQuery, columns, enableSorting, displayHeader, showActions);
        PagerFilter pagerFilter = new PagerFilter(numberToShow);
        pagerFilter.setStart(start);
        try {
            SearchResults results = this.searchProvider.search(linkedLabelledQuery.query, user, pagerFilter);
            String baseUrl = this.getBaseUrl(request);
            this.velocityRequestContextFactory.setVelocityRequestContext(baseUrl, request);
            IssueTable table = this.createIssueTable(results, linkedLabelledQuery, layout, isPaging, numberToShow, columnSortJql);
            return Response.ok((Object)table).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                String message = this.createIndexingUnavailableMessage();
                return this.createIndexingUnavailableResponse(message);
            }
            throw e;
        }
        catch (SearchException e) {
            log.error((Object)"Exception thrown while running search for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String createIndexingUnavailableMessage() {
        String msg2;
        String msg1 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing");
        if (this.permissionManager.hasPermission(0, this.authenticationContext.getUser())) {
            String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            msg2 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.configure", "<a href=\"" + baseUrl + "/secure/admin/jira/IndexAdmin.jspa\">", "</a>");
        } else {
            msg2 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.admin");
        }
        return msg1 + " " + msg2;
    }

    private List<ColumnLayoutItem> getColumns(String context, List<String> columnNames, boolean addDefaults, boolean useConfiguredCols) {
        ApplicationUser user = this.authenticationContext.getUser();
        try {
            if (useConfiguredCols) {
                ColumnLayout columnLayout = this.columnLayoutManager.getColumnLayout(user);
                return columnLayout.getAllVisibleColumnLayoutItems(user);
            }
            List list = this.tableLayoutUtils.getColumns(user, context, columnNames, addDefaults);
            if (columnNames != null && columnNames.size() == 1 && list.size() != 1 && (columnNames = Arrays.asList(columnNames.get(0).split(","))).size() > 1) {
                list = this.tableLayoutUtils.getColumns(user, context, columnNames, addDefaults);
            }
            return list;
        }
        catch (FieldException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ColumnLayoutException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ColumnLayoutStorageException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getBaseUrl(HttpServletRequest request) {
        String baseUrl = JiraUrl.constructBaseUrl((HttpServletRequest)request);
        if (baseUrl.endsWith(REST_CONTEXT_PATH)) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - REST_CONTEXT_PATH.length());
        }
        return baseUrl;
    }

    private SearchRequest getSearchRequestAndValidate(String filterParam, Collection<ValidationError> errors) {
        ApplicationUser user = this.authenticationContext.getUser();
        SearchRequest searchRequest = null;
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        if (StringUtils.isBlank((String)filterParam)) {
            errors.add(new ValidationError(FILTER_ID, "gadget.common.no.filter.id"));
        } else {
            Long filterId;
            if (filterParam.startsWith(JQL_PREFIX)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, filterParam.substring(JQL_PREFIX.length()));
                if (parseResult.isValid()) {
                    searchRequest = new SearchRequest(parseResult.getQuery());
                } else {
                    for (String errorMessage : parseResult.getErrors().getErrorMessages()) {
                        errors.add(new ValidationError(FILTER_ID, "gadget.common.invalid.filter.validationfailed", CollectionBuilder.newBuilder((Object[])new String[]{filterParam, errorMessage}).asList()));
                    }
                }
                filterId = null;
            } else {
                filterId = this.stripFilterPrefix(filterParam, FILTER_PREFIX);
                searchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, filterId);
            }
            if (searchRequest == null) {
                errors.add(new ValidationError(FILTER_ID, "gadget.common.invalid.filter.id", filterParam));
            } else {
                MessageSet messageSet = this.searchService.validateQuery(user, searchRequest.getQuery(), filterId);
                if (messageSet.hasAnyErrors()) {
                    for (String errorMessage : messageSet.getErrorMessages()) {
                        errors.add(new ValidationError(FILTER_ID, "gadget.common.invalid.filter.validationfailed", CollectionBuilder.newBuilder((Object[])new String[]{filterParam, errorMessage}).asList()));
                    }
                }
            }
        }
        return searchRequest;
    }

    Long stripFilterPrefix(String filterId, String prefix) {
        if (filterId.startsWith(prefix)) {
            String numPart = filterId.substring(prefix.length());
            return Long.valueOf(numPart);
        }
        return Long.valueOf(filterId);
    }

    private SearchRequest getSearchRequestAndValidateForIteration(String projectId, Collection<ValidationError> errors, boolean completed) {
        ApplicationUser user = this.authenticationContext.getUser();
        if (StringUtils.isBlank((String)projectId)) {
            errors.add(new ValidationError(PROJECT_ID, "gadget.common.project.none.selected"));
            return null;
        }
        Project project = this.projectManager.getProjectObj(this.stripFilterPrefix(projectId, PROJECT_PREFIX));
        if (project == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) {
            errors.add(new ValidationError(PROJECT_ID, "gadget.common.invalid.project"));
            return null;
        }
        Collection versions = this.versionManager.getVersionsUnreleased(project.getId(), false);
        if (versions.isEmpty()) {
            errors.add(new ValidationError(PROJECT_ID, "gadget.issuetable.common.no.unreleased.versions", project.getName()));
            return null;
        }
        Version version = (Version)versions.iterator().next();
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{project.getId()}).and().fixVersion(version.getId());
        if (completed) {
            builder.and().resolution().isNotEmpty();
        } else {
            builder.and().resolution().isEmpty();
        }
        SearchRequest searchRequest = new SearchRequest(builder.buildQuery());
        searchRequest.setName(project.getName() + " " + version.getName());
        return searchRequest;
    }

    private int validateNumberToShow(String fieldName, String numberToShow, Collection<ValidationError> errors) {
        try {
            int maxRows = this.getMaxRows();
            int validatedNum = Integer.valueOf(numberToShow);
            if (validatedNum <= 0) {
                errors.add(new ValidationError(fieldName, "gadget.common.num.negative"));
            } else if (validatedNum > maxRows) {
                errors.add(new ValidationError(fieldName, "gadget.common.num.overlimit", "" + maxRows));
            }
            return validatedNum;
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(fieldName, "gadget.common.num.nan"));
            return -1;
        }
    }

    private int getMaxRows() {
        try {
            if (this.applicationProperties != null) {
                String maxRowsStr = this.applicationProperties.getDefaultBackedString("jira.table.gadget.max.rows");
                if (StringUtils.isNotBlank((String)maxRowsStr)) {
                    return Integer.valueOf(maxRowsStr);
                }
                String logMessage = "'jira.table.gadget.max.rows' doesn't exist in jira-application.properties";
                maxRowsLogger.warn((Object)"'jira.table.gadget.max.rows' doesn't exist in jira-application.properties");
                log.info((Object)"'jira.table.gadget.max.rows' doesn't exist in jira-application.properties");
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"'jira.table.gadget.max.rows' contains something thats not a number!", (Throwable)e);
        }
        return 50;
    }

    void validateColumnNames(List<String> columnNames, Collection<ValidationError> errors) {
        if (columnNames != null && !columnNames.isEmpty()) {
            try {
                ArrayList<String> fieldsNotFound = new ArrayList<String>();
                ApplicationUser user = this.authenticationContext.getUser();
                Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
                for (String columnName : columnNames) {
                    if ("--default--".equalsIgnoreCase(columnName)) continue;
                    boolean found = false;
                    for (NavigableField availableField : availableFields) {
                        if (!columnName.equals(availableField.getId())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fieldsNotFound.add(columnName);
                }
                if (!fieldsNotFound.isEmpty()) {
                    String fieldsNotFoundString = StringUtils.join(fieldsNotFound, (String)", ");
                    errors.add(new ValidationError(COLUMN_NAMES, "gadget.issuetable.common.cols.not.found", fieldsNotFoundString));
                }
            }
            catch (FieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @XmlRootElement
    public static class IssueTable {
        @XmlElement
        private String table;
        @XmlElement
        private int displayed;
        @XmlElement
        private int startIndex;
        @XmlElement
        private int total;
        @XmlElement
        private int end;
        @XmlElement
        private int page;
        @XmlElement
        private int pageSize;
        @XmlElement
        private String url;
        @XmlElement
        private String title;
        @XmlElement
        private String description;
        @XmlElement
        private Map<String, String> columnSortJql;

        private IssueTable() {
        }

        IssueTable(String table, int displayed, int total, int startIndex, int end, int page, int pageSize, String url, String title, String description, Map<String, String> columnSortJql) {
            this.table = table;
            this.displayed = displayed;
            this.total = total;
            this.startIndex = startIndex;
            this.end = end;
            this.page = page;
            this.pageSize = pageSize;
            this.url = url;
            this.title = title;
            this.description = description;
            this.columnSortJql = columnSortJql;
        }
    }

    class LinkedLabelledQuery {
        private Query query;
        private String title;
        private String link;
        private String description;

        private LinkedLabelledQuery(Query query, String title, String link, String description) {
            this.query = query;
            this.title = title;
            this.link = link;
            this.description = description;
        }

        private LinkedLabelledQuery(SearchRequest searchRequest) {
            this(searchRequest.getQuery(), searchRequest.getName(), this$0.getURLFromSearchRequest(searchRequest), searchRequest.getDescription());
        }
    }
}

