/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.StatisticTypesProvider;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.ComparatorSelector;
import com.atlassian.jira.issue.statistics.util.DefaultFieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.ObjectToFieldValueMapper;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;

@Path(value="heatmap")
@AnonymousAllowed
@Produces(value={"application/json"})
public class HeatMapResource
extends SearchQueryBackedResource {
    private static final String SEARCH_QUERY = "projectOrFilterId";
    static final String STAT_TYPE = "statType";
    private static final String NUM_ISSUES = "numIssues";
    private static final String NUM_OCCURRENCES = "numOccurences";
    private final JiraAuthenticationContext authenticationContext;
    private final StatisticTypesProvider statisticTypesProvider;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final CustomFieldManager customFieldManager;
    static final String KEY_URL_GENERATOR = "completeDatasetUrlGenerator";
    static final String KEY_DATASET = "completeDataset";
    static final double MIN_FONT = 12.0;
    static final double MAX_FONT = 60.0;
    static final double FONT_INCREMENT = 5.0;
    static final double BIN_SIZE = 10.0;

    public HeatMapResource(@ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, StatisticTypesProvider statisticTypesProvider, @ComponentImport SearchService searchService, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport CustomFieldManager customFieldManager) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.statisticTypesProvider = statisticTypesProvider;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.authenticationContext = authenticationContext;
        this.customFieldManager = customFieldManager;
    }

    @GET
    @Path(value="/generate")
    public Response getHeatMap(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="statType") @DefaultValue(value="assignees") String statType) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        String displayName = this.validateStatType(errors, statType);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        try {
            Map<String, Object> chartParams = this.createHeatMap(statType, user, searchRequest);
            String title = this.getFilterTitle(params);
            String filterUrl = this.getFilterUrl(params);
            int issueCount = ((Long)chartParams.get(NUM_ISSUES)).intValue();
            int occurrenceCount = (Integer)chartParams.get(NUM_OCCURRENCES);
            DataRow[] data = (DataRow[])chartParams.get(KEY_DATASET);
            HeatMap heatMap = new HeatMap(title, filterUrl, occurrenceCount, issueCount, displayName, data);
            return Response.ok((Object)heatMap).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    Map<String, Object> createHeatMap(String statType, ApplicationUser user, SearchRequest searchRequest) {
        I18nHelper i18nBean = this.authenticationContext.getI18nHelper();
        try {
            Map.Entry statistic;
            SearchRequest clonedSearchRequest = new SearchRequest(searchRequest.getQuery());
            StatisticAccessorBean statBean = new StatisticAccessorBean(user, clonedSearchRequest);
            StatisticMapWrapper statWrapper = statBean.getAllFilterBy(statType);
            StatisticsMapper statMapper = statBean.getMapper(statType);
            DefaultFieldValueToDisplayTransformer fieldValueToDisplayTransformer = new DefaultFieldValueToDisplayTransformer(i18nBean, this.customFieldManager);
            int numRows = statWrapper.size() + (statWrapper.getIrrelevantCount() > 0 ? 1 : 0);
            VelocityRequestContext velocityRequestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            Comparator comparator = ComparatorSelector.getComparator((StatisticsMapper)statMapper);
            TreeMap rowOrdering = new TreeMap(comparator);
            int numOccurences = 0;
            for (Object o : statWrapper.entrySet()) {
                statistic = (Map.Entry)o;
                numOccurences += ((Number)statistic.getValue()).intValue();
            }
            numOccurences += statWrapper.getIrrelevantCount();
            for (Object o : statWrapper.entrySet()) {
                statistic = (Map.Entry)o;
                Object key = statistic.getKey();
                int issues = ((Number)statistic.getValue()).intValue();
                String url = this.createSearchUrl(user, clonedSearchRequest, statMapper, velocityRequestContext, key);
                DataRow dataRow = this.createDataRow(key, (FieldValueToDisplayTransformer<String>)fieldValueToDisplayTransformer, statType, numOccurences, url, numRows, issues);
                rowOrdering.put(key, dataRow);
            }
            DataRow[] dataRows = new DataRow[numRows];
            rowOrdering.values().toArray(dataRows);
            if (statWrapper.getIrrelevantCount() > 0) {
                DataRow dataRow;
                int issues = statWrapper.getIrrelevantCount();
                dataRows[rowOrdering.size()] = dataRow = this.createDataRow(FilterStatisticsValuesGenerator.IRRELEVANT, (FieldValueToDisplayTransformer<String>)fieldValueToDisplayTransformer, statType, numOccurences, null, numRows, issues);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(KEY_DATASET, dataRows);
            params.put(NUM_ISSUES, statWrapper.getTotalCount());
            params.put(NUM_OCCURRENCES, numOccurences);
            params.put(STAT_TYPE, statType);
            params.put("statisticTypeI18nName", this.getStatisticsTypeI18nName(i18nBean, statType));
            return params;
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating heat map", e);
        }
    }

    String createSearchUrl(ApplicationUser user, SearchRequest clonedSearchRequest, StatisticsMapper statMapper, VelocityRequestContext velocityRequestContext, Object key) {
        SearchRequest searchUrlSuffix = statMapper.getSearchUrlSuffix(key, clonedSearchRequest);
        return velocityRequestContext.getCanonicalBaseUrl() + this.searchService.getIssueSearchPath(user, SearchService.IssueSearchParameters.builder().query((Query)(searchUrlSuffix == null ? new QueryImpl() : searchUrlSuffix.getQuery())).build());
    }

    DataRow createDataRow(Object key, FieldValueToDisplayTransformer<String> fieldValueToDisplayTransformer, String statType, int totalIssues, String url, int numRows, int issues) {
        String name = (String)ObjectToFieldValueMapper.transform((String)statType, (Object)key, (String)url, fieldValueToDisplayTransformer);
        int percentage = 100 * issues / totalIssues;
        double fontSize = this.calculateFontSize(numRows, percentage);
        return new DataRow((Comparable)((Object)name), url, issues, percentage, fontSize);
    }

    double calculateFontSize(int numberOfData, double percentage) {
        return 12.0 + Math.min(60.0, 5.0 * (double)numberOfData * (double)Math.round(percentage / 10.0) * 10.0 / 100.0);
    }

    String getStatisticsTypeI18nName(I18nHelper i18nBean, String statisticType) {
        if (statisticType.startsWith("customfield_")) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(statisticType);
            if (customField == null) {
                throw new RuntimeException("No custom field with id '" + statisticType + "'");
            }
            if (customField.getCustomFieldSearcher() instanceof CustomFieldStattable) {
                return customField.getName();
            }
            return null;
        }
        return i18nBean.getText("gadget.filterstats.field.statistictype." + statisticType.toLowerCase());
    }

    String validateStatType(Collection<ValidationError> errors, String statType) {
        String displayName = this.statisticTypesProvider.getDisplayName(statType);
        if (StringUtils.isBlank((String)displayName)) {
            errors.add(new ValidationError(STAT_TYPE, "gadget.common.invalid.stat.type", statType));
        }
        return displayName;
    }

    @GET
    @Path(value="validate")
    public Response validateHeatMap(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="statType") String statType) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(queryString, errors, new HashMap<String, Object>());
        this.validateStatType(errors, statType);
        return this.createValidationResponse(errors);
    }

    @XmlRootElement
    @XmlType(namespace="com.atlassian.jira.gadgets.system.HeatMapResource")
    public static class DataRow {
        private Comparable key;
        @XmlElement
        private String url;
        @XmlElement
        private int value;
        @XmlElement
        private int percentage;
        @XmlElement
        private double fontSize;
        @XmlElement(name="key")
        private String keyString;

        public DataRow() {
        }

        DataRow(Comparable key, String url, int value, int percentage, double fontSize) {
            this.key = key;
            this.url = url;
            this.value = value;
            this.percentage = percentage;
            this.fontSize = fontSize;
            this.keyString = key.toString();
        }

        public Comparable getRawKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataRow dataRow = (DataRow)o;
            if (this.percentage != dataRow.percentage) {
                return false;
            }
            if (this.value != dataRow.value) {
                return false;
            }
            if (this.key != null ? !this.key.equals(dataRow.key) : dataRow.key != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(dataRow.url) : dataRow.url != null) {
                return false;
            }
            return this.fontSize == dataRow.fontSize;
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + this.value;
            result = 31 * result + this.percentage;
            long temp = this.fontSize != 0.0 ? Double.doubleToLongBits(this.fontSize) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }

    @XmlRootElement
    public static class HeatMap {
        @XmlElement
        private String filterTitle;
        @XmlElement
        private String filterUrl;
        @XmlElement
        private int issueCount;
        @XmlElement
        private int occurrenceCount;
        @XmlElement
        private String statType;
        @XmlElement
        private DataRow[] data;
        @XmlElement
        private int numberOfData;

        private HeatMap() {
        }

        public HeatMap(String filterTitle, String filterUrl, int occurrenceCount, int issueCount, String statType, DataRow[] data) {
            this.filterTitle = filterTitle;
            this.filterUrl = filterUrl;
            this.issueCount = issueCount;
            this.occurrenceCount = occurrenceCount;
            this.statType = statType;
            this.data = data;
            this.numberOfData = data == null ? 0 : data.length - 1;
        }
    }
}

