/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.gadgets.system.AbstractResource;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/favfilters")
@AnonymousAllowed
@Produces(value={"application/json"})
public class FavouriteFiltersResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(FavouriteFiltersResource.class);
    private JiraAuthenticationContext authenticationContext;
    private SearchRequestService searchRequestService;
    private SearchProvider searchProvider;
    private PermissionManager permissionManager;
    private VelocityRequestContextFactory velocityRequestContextFactory;

    public FavouriteFiltersResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchRequestService searchRequestService, @ComponentImport SearchProvider searchProvider, @ComponentImport PermissionManager permissionManager, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory) {
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.searchProvider = searchProvider;
        this.permissionManager = permissionManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @GET
    public Response getFavouriteFilters(@DefaultValue(value="false") @QueryParam(value="showCounts") boolean includeCount) {
        ApplicationUser user = this.authenticationContext.getUser();
        if (Users.isAnonymous((ApplicationUser)user)) {
            return Response.ok((Object)new NotLoggedIn()).cacheControl(CacheControl.NO_CACHE).build();
        }
        Collection searchRequests = this.searchRequestService.getFavouriteFilters(user);
        ArrayList<Filter> filters = new ArrayList<Filter>(searchRequests.size());
        try {
            for (SearchRequest searchRequest : searchRequests) {
                if (includeCount) {
                    try {
                        long count = this.searchProvider.searchCount(searchRequest.getQuery(), user);
                        filters.add(new Filter(searchRequest.getName(), searchRequest.getDescription(), searchRequest.getId(), count));
                    }
                    catch (SearchException e) {
                        log.warn("Error while running search for filter count:", (Throwable)e);
                        filters.add(new Filter(searchRequest.getName(), searchRequest.getDescription(), searchRequest.getId()));
                    }
                    continue;
                }
                filters.add(new Filter(searchRequest.getName(), searchRequest.getDescription(), searchRequest.getId()));
            }
            return Response.ok((Object)new FilterList(filters, includeCount)).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    private String createIndexingUnavailableMessage() {
        String msg2;
        String msg1 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing");
        if (this.permissionManager.hasPermission(0, this.authenticationContext.getUser())) {
            String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            msg2 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.configure", "<a href=\"" + baseUrl + "/secure/admin/jira/IndexAdmin.jspa\">", "</a>");
        } else {
            msg2 = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.admin");
        }
        return msg1 + " " + msg2;
    }

    @XmlRootElement
    public static class Filter {
        @XmlElement
        private String label;
        @XmlElement
        private String description;
        @XmlElement
        private Long value;
        @XmlElement
        private Long count;

        private Filter() {
        }

        Filter(String label, String description, Long value) {
            this.label = label;
            this.description = description;
            this.value = value;
        }

        Filter(String label, String description, Long value, Long count) {
            this.label = label;
            this.description = description;
            this.value = value;
            this.count = count;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getValue() {
            return this.value;
        }

        public Long getCount() {
            return this.count;
        }
    }

    @XmlRootElement
    public static class FilterList {
        @XmlElement
        private Collection<Filter> filters;
        @XmlElement
        private boolean includeCount;

        private FilterList() {
        }

        FilterList(Collection<Filter> filters, boolean includeCount) {
            this.filters = filters;
            this.includeCount = includeCount;
        }

        public Collection<Filter> getFilters() {
            return this.filters;
        }

        public boolean isIncludeCount() {
            return this.includeCount;
        }
    }

    @XmlRootElement
    public static class NotLoggedIn {
        @XmlElement
        private boolean notLoggedIn = false;

        private NotLoggedIn() {
        }

        public boolean isNotLoggedIn() {
            return this.notLoggedIn;
        }
    }
}

