/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecId;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecStore;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="externalgadgets")
@Consumes(value={"application/json"})
public class ExternalGadgetSpecResource {
    private final ExternalGadgetSpecStore externalGadgetSpecStore;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public ExternalGadgetSpecResource(@ComponentImport ExternalGadgetSpecStore externalGadgetSpecStore, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager) {
        this.externalGadgetSpecStore = externalGadgetSpecStore;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @DELETE
    @Path(value="{gadgetId}")
    public Response deleteExternalGadget(@PathParam(value="gadgetId") String gadgetId) {
        if (this.permissionManager.hasPermission(44, this.authenticationContext.getUser())) {
            if (gadgetId != null) {
                this.externalGadgetSpecStore.remove(ExternalGadgetSpecId.valueOf((String)gadgetId));
                return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
    }
}

