/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.gadgets.system.StatsSearchUrlBuilder;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.QueryOptimizer;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.IssueTypeStatisticsMapper;
import com.atlassian.jira.issue.statistics.ProjectStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.TwoDimensionalStatsMap;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.query.Query;

public class DefaultStatsSearchUrlBuilder
implements StatsSearchUrlBuilder {
    private SearchService searchService;
    private QueryOptimizer optimizer = new RedundantClausesQueryOptimizer();

    public DefaultStatsSearchUrlBuilder(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public String getSearchUrlForHeaderCell(Object axisObject, StatisticsMapper axisMapper, SearchRequest searchRequest) {
        SearchRequest searchUrlSuffix = axisMapper.getSearchUrlSuffix(axisObject, searchRequest);
        if (searchUrlSuffix == null) {
            return "";
        }
        Query query = this.optimizer.optimizeQuery(searchUrlSuffix.getQuery());
        return query != null ? this.getKickassQueryString(query) : "";
    }

    @Override
    public String getSearchUrlForCell(Object xAxisObject, Object yAxisObject, TwoDimensionalStatsMap statsMap, SearchRequest searchRequest) {
        SearchRequest srAfterSecond;
        SearchRequest srAfterFirst;
        StatisticsMapper xAxisMapper = statsMap.getxAxisMapper();
        StatisticsMapper yAxisMapper = statsMap.getyAxisMapper();
        if (this.isFirst(yAxisMapper, xAxisMapper)) {
            srAfterFirst = yAxisMapper.getSearchUrlSuffix(yAxisObject, searchRequest);
            srAfterSecond = xAxisMapper.getSearchUrlSuffix(xAxisObject, srAfterFirst);
        } else {
            srAfterFirst = xAxisMapper.getSearchUrlSuffix(xAxisObject, searchRequest);
            srAfterSecond = yAxisMapper.getSearchUrlSuffix(yAxisObject, srAfterFirst);
        }
        Query query = srAfterSecond != null ? this.optimizer.optimizeQuery(srAfterSecond.getQuery()) : null;
        return query != null ? this.getKickassQueryString(query) : "";
    }

    private String getKickassQueryString(Query query) {
        UrlBuilder url = new UrlBuilder("", "UTF-8", false);
        url.addParameter("jql", this.searchService.getJqlString(query));
        return url.toString();
    }

    private boolean isFirst(StatisticsMapper a, StatisticsMapper b) {
        if (a instanceof ProjectStatisticsMapper) {
            return true;
        }
        if (b instanceof ProjectStatisticsMapper) {
            return false;
        }
        if (a instanceof IssueTypeStatisticsMapper) {
            return true;
        }
        return !(b instanceof IssueTypeStatisticsMapper);
    }
}

