/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.TimeChart;
import com.atlassian.jira.gadgets.system.util.ResourceDateValidator;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.TimeSeriesCollection;

@Path(value="/averageage")
@AnonymousAllowed
@Produces(value={"application/json"})
public class AverageAgeChartResource
extends SearchQueryBackedResource {
    private static final String PERIOD_NAME = "periodName";
    private static final String DAYS = "daysprevious";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String RETURN_DATA = "returnData";
    private static final String INLINE = "inline";
    private final ChartFactory chartFactory;
    private final TimeZoneManager timeZoneManager;
    private final ResourceDateValidator resourceDateValidator;

    public AverageAgeChartResource(@ComponentImport ChartFactory chartFactory, @ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport SearchService searchService, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport TimeZoneManager timeZoneManager) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.chartFactory = chartFactory;
        this.timeZoneManager = timeZoneManager;
        this.resourceDateValidator = new ResourceDateValidator(applicationProperties);
    }

    @GET
    @Path(value="/generate")
    public Response generateChart(@Context HttpServletRequest request, @QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName, @QueryParam(value="returnData") @DefaultValue(value="false") boolean returnData, @QueryParam(value="width") @DefaultValue(value="450") int width, @QueryParam(value="height") @DefaultValue(value="300") int height, @QueryParam(value="inline") @DefaultValue(value="false") boolean inline) {
        if (StringUtils.isNotBlank((String)queryString) && !queryString.contains("-")) {
            queryString = "filter-" + queryString;
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        int numberOfDays = this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        if (!errors.isEmpty()) {
            return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder(errors).build()).cacheControl(CacheControl.NO_CACHE).build();
        }
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(user, searchRequest, width, height, inline);
        try {
            Chart chart = this.chartFactory.generateAverageAgeChart(context, numberOfDays, period);
            String location = chart.getLocation();
            String title = this.getFilterTitle(params);
            String filterUrl = this.getFilterUrl(params);
            String imageMap = chart.getImageMap();
            String imageMapName = chart.getImageMapName();
            TimeChart.TimeDataRow[] data = null;
            if (returnData) {
                TimeSeriesCollection dataSet = (TimeSeriesCollection)chart.getParameters().get("completeDataset");
                XYURLGenerator urlGenerator = (XYURLGenerator)chart.getParameters().get("completeDatasetUrlGenerator");
                data = this.generateTimeChartDataSet(dataSet, urlGenerator);
            }
            TimeChart averageAgeChart = new TimeChart(location, title, filterUrl, imageMap, imageMapName, data, width, height, chart.getBase64Image());
            return Response.ok((Object)averageAgeChart).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    TimeChart.TimeDataRow[] generateTimeChartDataSet(TimeSeriesCollection dataSet, XYURLGenerator urlGenerator) {
        return new TimeChart.Generator().generateDataSet(dataSet, urlGenerator, this.timeZoneManager);
    }

    @GET
    @Path(value="/validate")
    public Response validateChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName) {
        if (StringUtils.isNotBlank((String)queryString) && !queryString.contains("-")) {
            queryString = "filter-" + queryString;
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        return this.createValidationResponse(errors);
    }
}

