/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.util;

import com.atlassian.jira.dashboarditem.statistics.util.QueryUrlSupplier;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryUrlSupplierImpl
implements QueryUrlSupplier {
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JqlStringSupport jqlStringSupport;

    @Autowired
    public QueryUrlSupplierImpl(@ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport JqlStringSupport jqlStringSupport) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.jqlStringSupport = jqlStringSupport;
    }

    @Override
    @Nonnull
    public String getUrlForQuery(Query query) {
        UrlBuilder urlBuilder = this.getIssueUrlBuilder();
        this.addJqlParameter(urlBuilder, query);
        return urlBuilder.asUrlString();
    }

    @Override
    @Nonnull
    public String getUrlForQueryWithVersion(Query query, Version version) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)query);
        JqlClauseBuilder whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
        whereClauseBuilder.fixVersion(version.getId());
        return this.getUrlForQuery(whereClauseBuilder.buildQuery());
    }

    @Override
    @Nonnull
    public String getUrlForFilter(Long filterId) {
        UrlBuilder urlBuilder = this.getIssueUrlBuilder();
        this.addFilterParamter(urlBuilder, filterId);
        return urlBuilder.asUrlString();
    }

    private UrlBuilder getIssueUrlBuilder() {
        String baseUrl = this.getBaseUrl();
        return new UrlBuilder(baseUrl + "/issues/");
    }

    private void addFilterParamter(UrlBuilder urlBuilder, Long filterId) {
        urlBuilder.addParameter("filter", (Object)filterId);
    }

    private void addJqlParameter(UrlBuilder urlBuilder, Query query) {
        urlBuilder.addParameter("jql", this.jqlStringSupport.generateJqlString(query));
    }

    private String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }
}

