/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.service.versions;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.dashboarditem.statistics.service.versions.VersionsService;
import com.atlassian.jira.dashboarditem.statistics.service.versions.beans.ProjectVersionBean;
import com.atlassian.jira.dashboarditem.statistics.util.ProjectOrFilterQueryParser;
import com.atlassian.jira.dashboarditem.statistics.util.QueryParser;
import com.atlassian.jira.dashboarditem.statistics.util.QueryUrlSupplier;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.ProjectSearchInputTransformer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionsServiceImpl
implements VersionsService {
    private final VersionManager versionManager;
    private final SearchHandlerManager searchHandlerManager;
    private final ProjectService projectService;
    private final JiraAuthenticationContext authenticationContext;
    private final QueryParser queryParser;
    private final ProjectOrFilterQueryParser projectOrFilterQueryParser;
    private final QueryUrlSupplier queryUrlSupplier;

    @Autowired
    public VersionsServiceImpl(@ComponentImport VersionManager versionManager, @ComponentImport SearchHandlerManager searchHandlerManager, @ComponentImport ProjectService projectService, @ComponentImport JiraAuthenticationContext authenticationContext, QueryParser queryParser, ProjectOrFilterQueryParser projectOrFilterQueryParser, QueryUrlSupplier queryUrlSupplier) {
        this.versionManager = versionManager;
        this.searchHandlerManager = searchHandlerManager;
        this.projectService = projectService;
        this.queryParser = queryParser;
        this.authenticationContext = authenticationContext;
        this.projectOrFilterQueryParser = projectOrFilterQueryParser;
        this.queryUrlSupplier = queryUrlSupplier;
    }

    @Override
    public Either<List<ProjectVersionBean>, ErrorCollection> getVersions(@Nonnull String jql) {
        ApplicationUser user = this.authenticationContext.getUser();
        Either<Query, ErrorCollection> queryOrError = this.queryParser.getQuery(user, jql);
        if (queryOrError.isRight()) {
            return Either.right((Object)queryOrError.right().get());
        }
        Query query = (Query)queryOrError.left().get();
        Option<Query> filterQuery = this.projectOrFilterQueryParser.getFilterQuery(user, query);
        if (filterQuery.isDefined()) {
            query = (Query)filterQuery.get();
        }
        Collection<Project> projects = this.getProjectsForQuery(user, query);
        List<ProjectVersionBean> projectVersionBeanList = this.getVersionsForProjects(query, projects);
        return Either.left(projectVersionBeanList);
    }

    private List<ProjectVersionBean> getVersionsForProjects(Query query, Collection<Project> projects) {
        ArrayList<ProjectVersionBean> projectVersionBeanList = new ArrayList<ProjectVersionBean>();
        for (Project project : projects) {
            List versions = this.versionManager.getVersions(project.getId(), false);
            for (Version version : versions) {
                String url = this.queryUrlSupplier.getUrlForQueryWithVersion(query, version);
                projectVersionBeanList.add(new ProjectVersionBean(version, project, url));
            }
        }
        return projectVersionBeanList;
    }

    private Collection<Project> getProjectsForQuery(final ApplicationUser user, Query query) {
        IssueSearcher projectSearcher = this.searchHandlerManager.getSearcher("project");
        ProjectSearchInputTransformer searchInputTransformer = (ProjectSearchInputTransformer)projectSearcher.getSearchInputTransformer();
        Set projectIds = searchInputTransformer.getIdValuesAsStrings(user, query);
        Iterable projects = Iterables.transform((Iterable)projectIds, (Function)new Function<String, Project>(){

            public Project apply(@Nullable String input) {
                Long id = new Long(input);
                ProjectService.GetProjectResult projectResult = VersionsServiceImpl.this.projectService.getProjectById(user, id);
                if (projectResult.isValid()) {
                    return projectResult.getProject();
                }
                return null;
            }
        });
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)projects, (Predicate)Predicates.notNull()));
    }
}

