/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.service.statistics.searcher;

import com.atlassian.jira.dashboarditem.statistics.service.statistics.searcher.beans.StatisticsSearchResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.searcher.beans.StatisticsSearchResultRowBean;
import com.atlassian.jira.dashboarditem.statistics.util.QueryUrlSupplier;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.DefaultFieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.ObjectToFieldValueMapper;
import com.atlassian.jira.issue.statistics.util.OneDimensionalTermHitCollector;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.search.Collector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticsSearcher {
    private final QueryUrlSupplier queryUrlSupplier;
    private final ProjectManager projectManager;
    private final I18nHelper i18nHelper;
    private final CustomFieldManager customFieldManager;
    private final SearchProvider searchProvider;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ReaderCache readerCache;
    private final FieldManager fieldManager;

    @Autowired
    public StatisticsSearcher(QueryUrlSupplier queryUrlSupplier, @ComponentImport ProjectManager projectManager, @ComponentImport I18nHelper i18nHelper, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport SearchProvider searchProvider, @ComponentImport FieldVisibilityManager fieldVisibilityManager, @ComponentImport ReaderCache readerCache, @ComponentImport FieldManager fieldManager) {
        this.queryUrlSupplier = queryUrlSupplier;
        this.projectManager = projectManager;
        this.i18nHelper = i18nHelper;
        this.customFieldManager = customFieldManager;
        this.searchProvider = searchProvider;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldManager = fieldManager;
    }

    public StatisticsSearchResultBean completeOneDimensionalSearch(ApplicationUser user, Query query, String statType) throws SearchException {
        return this.completeOneDimensionalSearch(user, query, statType, OrderBy.TOTAL, Direction.DESC);
    }

    public StatisticsSearchResultBean completeOneDimensionalSearch(ApplicationUser user, Query query, String statType, OrderBy orderBy, Direction direction) throws SearchException {
        StatisticsMapper mapper = new FilterStatisticsValuesGenerator().getStatsMapper(statType);
        OneDimensionalTermHitCollector hitCollector = new OneDimensionalTermHitCollector(mapper.getDocumentConstant(), this.fieldVisibilityManager, this.readerCache, this.fieldManager, this.projectManager);
        this.searchProvider.search(query, user, (Collector)hitCollector);
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Map.Entry entry : hitCollector.getResult().entrySet()) {
            String fieldValue = (String)entry.getKey();
            Object objectValue = mapper.getValueFromLuceneField(fieldValue);
            if (!mapper.isValidValue(objectValue)) continue;
            if (map.containsKey(objectValue)) {
                Integer currentValue = (Integer)map.get(objectValue);
                map.put(objectValue, (Integer)entry.getValue() + currentValue);
                continue;
            }
            map.put(objectValue, (Integer)entry.getValue());
        }
        DefaultFieldValueToDisplayTransformer fieldValueToDisplayTransformer = new DefaultFieldValueToDisplayTransformer(this.i18nHelper, this.customFieldManager);
        StatisticMapperWrappingSearchRequestAppender searchRequestAppender = mapper instanceof SearchRequestAppender.Factory ? ((SearchRequestAppender.Factory)mapper).getSearchRequestAppender() : new StatisticMapperWrappingSearchRequestAppender(mapper);
        Long total = hitCollector.getHitCount();
        ArrayList<StatisticsSearchResultRowBean> results = new ArrayList<StatisticsSearchResultRowBean>();
        for (Map.Entry entry : map.entrySet()) {
            String key = StringEscapeUtils.unescapeHtml((String)((String)ObjectToFieldValueMapper.transform((String)statType, entry.getKey(), null, (FieldValueToDisplayTransformer)fieldValueToDisplayTransformer)));
            Long value = new Long(((Integer)entry.getValue()).intValue());
            SearchRequest urlSearchRequest = searchRequestAppender.appendInclusiveSingleValueClause(entry.getKey(), new SearchRequest(query));
            String url = this.queryUrlSupplier.getUrlForQuery(urlSearchRequest.getQuery());
            StatisticsSearchResultRowBean row = new StatisticsSearchResultRowBean(key, url, value);
            results.add(row);
        }
        if (hitCollector.getIrrelevantCount() > 0L) {
            String key = this.i18nHelper.getText("common.concepts.irrelevant");
            Long l = hitCollector.getIrrelevantCount();
            StatisticsSearchResultRowBean row = new StatisticsSearchResultRowBean(key, null, l);
            results.add(row);
        }
        Collections.sort(results, new Comparator<StatisticsSearchResultRowBean>(){

            @Override
            public int compare(StatisticsSearchResultRowBean first, StatisticsSearchResultRowBean second) {
                int valueComparison = second.getValue().compareTo(first.getValue());
                if (valueComparison == 0) {
                    return first.getKey().compareTo(second.getKey());
                }
                return valueComparison;
            }
        });
        return new StatisticsSearchResultBean(total, results);
    }

    private static class StatisticMapperWrappingSearchRequestAppender<T>
    implements SearchRequestAppender<T> {
        private final StatisticsMapper<T> statisticsMapper;

        public StatisticMapperWrappingSearchRequestAppender(StatisticsMapper<T> statisticsMapper) {
            this.statisticsMapper = (StatisticsMapper)Assertions.notNull(statisticsMapper);
        }

        public SearchRequest appendInclusiveSingleValueClause(T value, SearchRequest searchRequest) {
            return this.statisticsMapper.getSearchUrlSuffix(value, searchRequest);
        }

        public SearchRequest appendExclusiveMultiValueClause(Iterable<? extends T> values, SearchRequest searchRequest) {
            return null;
        }
    }

    public static enum Direction {
        ASC,
        DESC;

    }

    public static enum OrderBy {
        TOTAL,
        NATURAL;

    }
}

