/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.DateCountInPeriodService;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.DateCountParametersBuilder;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.beans.DateCountInPeriodResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.field.Field;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.operation.Operation;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.period.TimePeriod;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/dateCountInPeriod")
@AnonymousAllowed
public class DateCountInPeriodResource {
    static final String SEARCH_JQL = "jql";
    static final String FIELD = "field";
    static final String PERIOD = "period";
    static final String DAYS_PREVIOUS = "daysprevious";
    static final String OPERATION = "operation";
    static final String INCLUDE_VERSIONS = "includeVersions";
    private final DateCountInPeriodService dateCountInPeriodService;
    private final JiraAuthenticationContext authenticationContext;
    private final ResponseFactory responseFactory;

    public DateCountInPeriodResource(DateCountInPeriodService dateCountInPeriodService, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ResponseFactory responseFactory) {
        this.dateCountInPeriodService = dateCountInPeriodService;
        this.authenticationContext = authenticationContext;
        this.responseFactory = responseFactory;
    }

    @GET
    @Produces(value={"application/json"})
    public Response completeCreatedVsResolved(@QueryParam(value="jql") String jql, @QueryParam(value="field") List<String> fieldNames, @QueryParam(value="period") String periodName, @QueryParam(value="daysprevious") Integer daysPrevious, @QueryParam(value="includeVersions") boolean includeVersions, @QueryParam(value="operation") String operationName) {
        ErrorCollection errors = this.validateParameters(fieldNames, periodName, operationName);
        if (errors.hasAnyErrors()) {
            return this.responseFactory.generateFieldErrorResponse(errors);
        }
        Set<Field> fields = this.getFieldSet(fieldNames);
        TimePeriod period = TimePeriod.valueOf(periodName);
        Operation operation = Operation.valueOf(operationName);
        DateCountParametersBuilder builder = new DateCountParametersBuilder().jql(jql).fields(fields).period(period).daysPrevious(daysPrevious).operation(operation).includeVersions(includeVersions);
        Either<DateCountInPeriodResultBean, ErrorCollection> resultOrError = this.dateCountInPeriodService.collectData(builder.build());
        if (resultOrError.isRight()) {
            return this.responseFactory.generateErrorResponse((ErrorCollection)resultOrError.right().get());
        }
        return Response.ok((Object)resultOrError.left().get()).build();
    }

    private ErrorCollection validateParameters(@Nullable Collection<String> fields, @Nullable String period, @Nullable String operation) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (fields == null || fields.size() == 0) {
            this.addValidationError((ErrorCollection)errors, FIELD, i18nHelper.getText("rest.missing.field", FIELD));
        } else {
            for (String field : fields) {
                try {
                    Field.valueOf(field);
                }
                catch (IllegalArgumentException ex) {
                    this.addValidationError((ErrorCollection)errors, FIELD, i18nHelper.getText("rest.invalid.field.valid.fields", Arrays.toString((Object[])Field.values())));
                }
            }
        }
        if (period == null) {
            this.addValidationError((ErrorCollection)errors, PERIOD, i18nHelper.getText("rest.missing.field", PERIOD));
        } else {
            try {
                TimePeriod.valueOf(period);
            }
            catch (IllegalArgumentException ex) {
                this.addValidationError((ErrorCollection)errors, PERIOD, i18nHelper.getText("rest.invalid.field.valid.fields", Arrays.toString((Object[])TimePeriod.values())));
            }
        }
        if (operation == null) {
            this.addValidationError((ErrorCollection)errors, OPERATION, i18nHelper.getText("rest.missing.field", OPERATION));
        } else {
            try {
                Operation.valueOf(operation);
            }
            catch (IllegalArgumentException ex) {
                this.addValidationError((ErrorCollection)errors, OPERATION, i18nHelper.getText("rest.invalid.field.valid.fields", Arrays.toString((Object[])Operation.values())));
            }
        }
        return errors;
    }

    private void addValidationError(ErrorCollection errors, String field, String message) {
        errors.addError(field, message, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    private Set<Field> getFieldSet(Collection<String> fieldNames) {
        return Sets.immutableEnumSet((Iterable)Iterables.transform(fieldNames, (Function)new Function<String, Field>(){

            public Field apply(@Nullable String input) {
                return Field.valueOf(input);
            }
        }));
    }
}

