/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.login;

import com.atlassian.jira.bc.security.login.LoginProperties;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class LoginContextProvider
implements ContextProvider {
    private final ApplicationProperties applicationProperties;
    private final RecoveryMode recoveryMode;
    private final HelpUrls helpUrls;
    private final JiraAuthenticationContext authenticationContext;
    private final LoginService loginService;

    public LoginContextProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport LoginService loginService, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport RecoveryMode recoveryMode, @ComponentImport HelpUrls helpUrls) {
        this.loginService = loginService;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.recoveryMode = recoveryMode;
        this.helpUrls = helpUrls;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        LoginProperties loginProperties = this.loginService.getLoginProperties(this.authenticationContext.getUser(), ExecutingHttpRequest.get());
        HashMap newContext = Maps.newHashMap(context);
        newContext.put("showCaptcha", loginProperties.isElevatedSecurityCheckShown());
        newContext.put("isPublicMode", loginProperties.isPublicMode());
        newContext.put("adminFormOn", String.valueOf(this.applicationProperties.getOption("jira.show.contact.administrators.form")));
        newContext.put("showForgotPassword", !loginProperties.isExternalPasswordManagement() && !loginProperties.isExternalUserManagement());
        newContext.put("showRememberMe", loginProperties.isAllowCookies());
        newContext.put("errorMessage", "");
        newContext.put("captchaTimestamp", System.currentTimeMillis());
        newContext.put("recoveryModeEnabled", this.recoveryMode.isRecoveryModeOn());
        newContext.put("recoveryModeUser", this.recoveryMode.getRecoveryUsername().getOrNull());
        newContext.put("recoveryModeHelpUrl", this.helpUrls.getUrl("recovery-mode").getUrl());
        return newContext;
    }
}

