/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.model;

import com.atlassian.jira.plugins.importer.bitbucket.scribe.DoWithSalCallback;
import com.atlassian.jira.plugins.importer.bitbucket.scribe.RequestFactoryHolder;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.io.IOException;
import org.scribe.exceptions.OAuthConnectionException;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Verb;

public class SalOAuthRequest
extends OAuthRequest {
    public SalOAuthRequest(Verb verb, String url) {
        super(verb, url);
    }

    public <RETURN_TYPE> RETURN_TYPE sendViaSal(DoWithSalCallback<RETURN_TYPE> cb) {
        try {
            return this.sendInternal(cb);
        }
        catch (Exception e) {
            throw new OAuthConnectionException(e);
        }
    }

    private <RETURN_TYPE> RETURN_TYPE sendInternal(final DoWithSalCallback<RETURN_TYPE> cb) throws Exception {
        String urlToGo = this.getCompleteUrl();
        Request.MethodType requestMethod = this.getMethod();
        Request request = RequestFactoryHolder.getRequestFactory().createRequest(requestMethod, urlToGo);
        request.setConnectionTimeout(30000);
        request.setSoTimeout(30000);
        this.setHeaders(request);
        if (this.getVerb().equals((Object)Verb.PUT) || this.getVerb().equals((Object)Verb.POST)) {
            this.setPayloadParams(request);
        }
        return (RETURN_TYPE)request.executeAndReturn(new ReturningResponseHandler<Response, RETURN_TYPE>(){

            public RETURN_TYPE handle(Response response) throws ResponseException {
                return cb.handleResponse(response);
            }
        });
    }

    private Request.MethodType getMethod() {
        switch (this.getVerb()) {
            case POST: {
                return Request.MethodType.POST;
            }
            case PUT: {
                return Request.MethodType.PUT;
            }
            case DELETE: {
                return Request.MethodType.DELETE;
            }
        }
        return Request.MethodType.GET;
    }

    private void setHeaders(Request<?, Response> request) {
        if (this.getHeaders() != null) {
            for (String key : this.getHeaders().keySet()) {
                request.setHeader(key, (String)this.getHeaders().get(key));
            }
        }
    }

    private void setPayloadParams(Request<?, Response> request) throws IOException {
        if (this.getBodyParams() != null) {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            request.setEntity((Object)this.getBodyParams().asFormUrlEncodedString());
        }
    }
}

