/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.BitbucketApi;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.collect.ImmutableList;
import org.scribe.builder.ServiceBuilder;
import org.scribe.exceptions.OAuthConnectionException;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;
import webwork.action.ActionContext;

public class SetupPage
extends AbstractSetupPage {
    private final ConfigFileHandler configFileHandler;
    private final String jiraUrl;
    private final String key = "3GR5ujDCxcCeQ5G6MS";
    private final String secret = "rkJSRTUPKGMsfdhbA3r4XNtw5wRfPC6k";

    public SetupPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ConfigFileHandler configFileHandler, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
        this.configFileHandler = configFileHandler;
        this.jiraUrl = applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String doDefault() throws Exception {
        if (!this.isAdministrator()) {
            return "denied";
        }
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean((AbstractSetupPage)this)) {
            return "input";
        }
        if (this.isNextClicked()) {
            Token requestToken;
            OAuthService service = new ServiceBuilder().provider(BitbucketApi.class).signatureType(SignatureType.Header).apiKey("3GR5ujDCxcCeQ5G6MS").apiSecret("rkJSRTUPKGMsfdhbA3r4XNtw5wRfPC6k").callback(this.jiraUrl + "/secure/admin/views/ReceiveOauthCodePage!default.jspa?externalSystem=com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:BitbucketImporterKey").build();
            try {
                requestToken = service.getRequestToken();
            }
            catch (OAuthConnectionException exception) {
                this.addErrorMessage(exception.getLocalizedMessage());
                return "input";
            }
            ActionContext.getSession().put("issue.importer.jira.bitbucket.oauthRequestToken", requestToken);
            BitbucketImporterConfigBean configBean = this.getConfigBean();
            configBean.getBitbucketImporterClient().setService(service);
            this.getRedirect(service.getAuthorizationUrl(requestToken), true);
            return "none";
        }
        return super.doExecute();
    }

    protected void doValidation() {
        if (this.isPreviousClicked()) {
            return;
        }
        super.doValidation();
        this.configFileHandler.verifyConfigFileParam((AbstractSetupPage)this);
    }

    public BitbucketImporterConfigBean getConfigBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                return null;
            }
            return (BitbucketImporterConfigBean)this.getController().getImportProcessBeanFromSession().getConfigBean();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:setupPage");
    }
}

