/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.web;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImportProcessBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class ProjectMappingsPage
extends ImporterProjectMappingsPage {
    public ProjectMappingsPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport ProjectService projectService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManger, @ComponentImport CreateProjectManager createProjectManager) {
        super(usageTrackingService, projectService, webInterfaceManager, pluginAccessor, projectManger, createProjectManager);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (this.isNextClicked()) {
            String redirect = "FetchDataPage!default.jspa?externalSystem=com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:BitbucketImporterKey";
            return this.getRedirect("FetchDataPage!default.jspa?externalSystem=com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:BitbucketImporterKey", true);
        }
        return super.doExecute();
    }

    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        if (this.isNextClicked()) {
            BitbucketImporterConfigBean bitbucketImporterConfigBean = (BitbucketImporterConfigBean)this.getBitbucketImportProcessBean().getConfigBean();
            List<String> projects = bitbucketImporterConfigBean.getSelectedProjects();
            ArrayList<String> failedProjects = new ArrayList<String>();
            for (String project : projects) {
                if (bitbucketImporterConfigBean.getBitbucketImporterClient().isAdminOnRepo(project)) continue;
                failedProjects.add(project);
            }
            if (!failedProjects.isEmpty()) {
                this.addErrorMessage("You need administrator privileges on the following repositories", "<ul><li>" + Joiner.on((String)"</li><li>").join(failedProjects) + "</li></ul>");
            }
        }
    }

    private BitbucketImportProcessBean getBitbucketImportProcessBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                return null;
            }
            return (BitbucketImportProcessBean)this.getController().getImportProcessBeanFromSession();
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

