/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.transformer;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.model.Attachment;
import com.atlassian.jira.plugins.importer.bitbucket.model.Comment;
import com.atlassian.jira.plugins.importer.bitbucket.model.Issue;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.AttachmentTransformer;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.CommentTransformer;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.MarkupTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class IssueTransformer
implements Function<Issue, ExternalIssue> {
    private final ImportLogger logger;
    private final ValueMappingHelper valueMappingHelper;
    private final Collection<Attachment> projectAttachments;
    private static final AttachmentTransformer attachmentTransformer = new AttachmentTransformer();
    private final Collection<Comment> projectComments;
    private static final CommentTransformer commentTransformer = new CommentTransformer();
    private static final Function<String, String> markupTransformer = new MarkupTransformer();

    public IssueTransformer(Collection<Comment> projectComments, Collection<Attachment> projectAttachments, BitbucketImporterConfigBean bitbucketConfigBean, ImportLogger logger) {
        this.logger = logger;
        this.valueMappingHelper = (ValueMappingHelper)Preconditions.checkNotNull((Object)bitbucketConfigBean.getValueMappingHelper());
        this.projectAttachments = projectAttachments;
        this.projectComments = projectComments;
    }

    public ExternalIssue apply(Issue input) {
        String kindMappedValue;
        String statusMappedValue;
        ExternalIssue issue = new ExternalIssue();
        issue.setExternalId(Integer.toString(input.getId()));
        issue.setSummary((String)markupTransformer.apply((Object)input.getTitle()));
        issue.setDescription((String)markupTransformer.apply((Object)input.getContent()));
        String priorityMappedValue = this.valueMappingHelper.getValueMapping("priority", input.getPriority());
        if (!"<<blank>>".equals(priorityMappedValue)) {
            issue.setPriority(StringUtils.isBlank((String)priorityMappedValue) ? input.getPriority() : priorityMappedValue);
        }
        issue.setStatus(StringUtils.isBlank((String)(statusMappedValue = this.valueMappingHelper.getValueMapping("status", input.getStatus()))) ? input.getStatus() : statusMappedValue);
        String resolutionMappedValue = this.valueMappingHelper.getValueMapping("resolution", input.getStatus());
        if (!"<<blank>>".equals(resolutionMappedValue)) {
            issue.setResolution(StringUtils.isBlank((String)resolutionMappedValue) ? input.getResolution() : resolutionMappedValue);
        }
        issue.setIssueType(StringUtils.isBlank((String)(kindMappedValue = this.valueMappingHelper.getValueMapping("kind", input.getKind()))) ? input.getKind() : kindMappedValue);
        issue.setAffectedVersions(input.getVersion() == null ? null : Collections.singleton(input.getVersion()));
        issue.setFixedVersions(input.getMilestone() == null ? null : Collections.singleton(input.getMilestone()));
        issue.setCreated(input.getCreated_on());
        DateTime updated = this.latest(input.getUpdated_on(), input.getEdited_on());
        updated = this.latest(updated, input.getContent_updated_on());
        issue.setUpdated(updated);
        issue.setAssignee(input.getAssignee());
        issue.setReporter(input.getReporter());
        if (input.getComponent() != null) {
            issue.setComponents((Iterable)ImmutableList.of((Object)input.getComponent()));
        }
        issue.setWatchers(input.getWatchers());
        Collection<Comment> commentsForIssue = this.getCommentsForIssue(input.getId());
        issue.setComments(Collections2.transform(commentsForIssue, (Function)commentTransformer));
        Collection<Attachment> attachmentsForIssue = this.getAttachmentsForIssue(input.getId());
        issue.setAttachments((List)Lists.newArrayList((Iterable)Collections2.transform(attachmentsForIssue, (Function)attachmentTransformer)));
        return issue;
    }

    private DateTime latest(DateTime date1, DateTime date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isAfter((ReadableInstant)date2) ? date1 : date2;
    }

    private Collection<Attachment> getAttachmentsForIssue(final int issueId) {
        return Collections2.filter(this.projectAttachments, (Predicate)new Predicate<Attachment>(){

            public boolean apply(Attachment attachment) {
                return attachment.getIssue() == issueId;
            }
        });
    }

    private Collection<Comment> getCommentsForIssue(final int issueId) {
        return Collections2.filter(this.projectComments, (Predicate)new Predicate<Comment>(){

            public boolean apply(Comment comment) {
                return comment.getIssue() == issueId;
            }
        });
    }
}

