/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.model;

import com.atlassian.jira.plugins.importer.bitbucket.model.Attachment;
import com.atlassian.jira.plugins.importer.bitbucket.model.Comment;
import com.atlassian.jira.plugins.importer.bitbucket.model.Issue;
import com.atlassian.jira.plugins.importer.bitbucket.model.RepositoryExportStatus;
import com.atlassian.jira.plugins.importer.bitbucket.model.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class Project {
    private final String name;
    private final List<Issue> issues = Lists.newArrayList();
    private final Set<String> components = Sets.newTreeSet();
    private final Set<String> milestones = Sets.newTreeSet();
    private final Set<String> versions = Sets.newTreeSet();
    private final List<Attachment> attachments = Lists.newArrayList();
    private final List<Comment> comments = Lists.newArrayList();
    private final Set<User> users = Sets.newHashSet();

    private Project(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    private void addUser(String user) {
        if (user != null) {
            this.users.add(new User(user));
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getComponents() {
        return ImmutableSet.copyOf(this.components);
    }

    public Set<String> getMilestones() {
        return ImmutableSet.copyOf(this.milestones);
    }

    public Set<String> getVersions() {
        return ImmutableSet.copyOf(this.versions);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public static class Parser {
        private static final Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new DateTimeDeserializer()).enableComplexMapKeySerialization().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setPrettyPrinting().create();

        private static void addStringFromObjectToCollection(Collection<String> result, JsonObject parsedMap, String outerObjectName, String innnerObjectAtributeName) {
            if (parsedMap.has(outerObjectName)) {
                JsonArray array = parsedMap.get(outerObjectName).getAsJsonArray();
                Iterator iterator = array.iterator();
                while (iterator.hasNext()) {
                    JsonObject value = ((JsonElement)iterator.next()).getAsJsonObject();
                    result.add(value.get(innnerObjectAtributeName).getAsString());
                }
            }
        }

        private static <T> void addValuesFromObjectToCollection(Collection<T> result, JsonObject parsedMap, String outerObjectName, Class<T> clazz) {
            if (parsedMap.has(outerObjectName)) {
                JsonArray array = parsedMap.get(outerObjectName).getAsJsonArray();
                Iterator iterator = array.iterator();
                while (iterator.hasNext()) {
                    result.add(gson.fromJson((JsonElement)iterator.next(), clazz));
                }
            }
        }

        public static Project parseProject(String name, InputStream in) throws IOException {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)in);
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, "UTF-8"));
            JsonParser parser = new JsonParser();
            JsonObject mainMap = parser.parse(reader).getAsJsonObject();
            Project project = new Project(name);
            Parser.addStringFromObjectToCollection(project.milestones, mainMap, "milestones", "name");
            Parser.addStringFromObjectToCollection(project.versions, mainMap, "versions", "name");
            Parser.addStringFromObjectToCollection(project.components, mainMap, "components", "name");
            Parser.addValuesFromObjectToCollection(project.issues, mainMap, "issues", Issue.class);
            Parser.addValuesFromObjectToCollection(project.attachments, mainMap, "attachments", Attachment.class);
            Parser.addValuesFromObjectToCollection(project.comments, mainMap, "comments", Comment.class);
            for (Attachment attachment : project.attachments) {
                project.addUser(attachment.getUser());
            }
            for (Comment comment : project.comments) {
                project.addUser(comment.getUser());
            }
            for (Issue issue : project.issues) {
                project.addUser(issue.getAssignee());
                project.addUser(issue.getReporter());
                for (String userName : issue.getWatchers()) {
                    project.addUser(userName);
                }
            }
            return project;
        }

        public static String parseCurrentUserData(InputStream in) throws UnsupportedEncodingException {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)in), "UTF-8"));
            JsonParser parser = new JsonParser();
            JsonObject mainMap = parser.parse(reader).getAsJsonObject();
            String userName = null;
            if (mainMap.has("user")) {
                JsonObject map = mainMap.get("user").getAsJsonObject();
                userName = map.get("username").getAsString();
            }
            return userName;
        }

        public static RepositoryExportStatus parseRepositoryExportStatus(InputStream in) throws UnsupportedEncodingException {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)in), "UTF-8"));
            return (RepositoryExportStatus)gson.fromJson(reader, RepositoryExportStatus.class);
        }

        public static List<String> parseVisibleRepositories(InputStream in, String currentUsername) throws UnsupportedEncodingException {
            ArrayList projects = Lists.newArrayList();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)in), "UTF-8"));
            JsonParser parser = new JsonParser();
            JsonArray all = parser.parse(reader).getAsJsonArray();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                JsonObject value = ((JsonElement)iterator.next()).getAsJsonObject();
                String owner = value.get("owner").getAsString();
                if (!value.get("has_issues").getAsBoolean()) continue;
                projects.add(owner + "/" + value.get("slug").getAsString());
            }
            return projects;
        }

        private static class DateTimeDeserializer
        implements JsonDeserializer<DateTime> {
            private DateTimeDeserializer() {
            }

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString());
            }
        }
    }
}

