/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.mapping;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.model.BitbucketStatus;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;

public class StatusValueMappingDefinition
implements ValueMappingDefinition {
    private final BitbucketImporterConfigBean configBean;

    public StatusValueMappingDefinition(BitbucketImporterConfigBean configBean) {
        this.configBean = configBean;
    }

    public String getExternalFieldId() {
        return "status";
    }

    public String getDescription() {
        return null;
    }

    public Set<String> getDistinctValues() {
        return BitbucketStatus.ALL_VALUES;
    }

    public String getJiraFieldId() {
        return "status";
    }

    public Collection<ValueMappingEntry> getTargetValues() {
        return Collections2.transform(this.getPossibleStatuses(), (Function)new Function<Status, ValueMappingEntry>(){

            public ValueMappingEntry apply(Status input) {
                return new ValueMappingEntry(input.getName(), input.getId());
            }
        });
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        Collection<Status> statuses = this.getPossibleStatuses();
        Collection<Status> toDo = this.byCategory(statuses, "new");
        Collection<Status> inProgress = this.byCategory(statuses, "indeterminate");
        Collection<Status> complete = this.byCategory(statuses, "done");
        return ImmutableList.of((Object)new ValueMappingEntry(BitbucketStatus.NEW.getValue(), toDo.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.OPEN.getValue(), toDo.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.ON_HOLD.getValue(), inProgress.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.RESOLVED.getValue(), complete.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.DUPLICATE.getValue(), complete.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.INVALID.getValue(), complete.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.WONTFIX.getValue(), complete.iterator().next().getId()), (Object)new ValueMappingEntry(BitbucketStatus.CLOSED.getValue(), complete.iterator().next().getId()));
    }

    public boolean canBeBlank() {
        return false;
    }

    public boolean canBeImportedAsIs() {
        return false;
    }

    public boolean canBeCustom() {
        return false;
    }

    public boolean isMandatory() {
        return true;
    }

    private Collection<Status> getPossibleStatuses() {
        final WorkflowSchemeManager workflowSchemeManager = ComponentAccessor.getWorkflowSchemeManager();
        final WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
        final ProjectManager projectManager = ComponentAccessor.getProjectManager();
        ImmutableSet workflows = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.configBean.getSelectedProjects(), (Function)new Function<String, Collection<String>>(){

            public Collection<String> apply(String input) {
                Project project = projectManager.getProjectObjByKey(StatusValueMappingDefinition.this.configBean.getProjectKey(input));
                if (project != null) {
                    return workflowSchemeManager.getWorkflowSchemeObj(project).getMappings().values();
                }
                return workflowSchemeManager.getDefaultWorkflowScheme().getMappings().values();
            }
        })));
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)workflows, (Function)new Function<String, Collection<Status>>(){

            public Collection<Status> apply(String input) {
                JiraWorkflow workflow = workflowManager.getWorkflow(input);
                return workflow.getLinkedStatusObjects();
            }
        })));
    }

    private Collection<Status> byCategory(Collection<Status> statuses, final String category) {
        ImmutableList byCategory = ImmutableList.copyOf((Iterable)Iterables.filter(statuses, (Predicate)new Predicate<Status>(){

            public boolean apply(Status input) {
                return input.getStatusCategory().getKey().equals(category);
            }
        }));
        if (byCategory.isEmpty()) {
            return statuses;
        }
        return byCategory;
    }
}

