/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.mapping;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class IssueTypeValueMappingDefinition
implements ValueMappingDefinition {
    private static final String KIND = "kind";
    private static final String BUG = "bug";
    private static final String ENHANCEMENT = "enhancement";
    private static final String PROPOSAL = "proposal";
    private static final String TASK = "task";
    private final ConstantsManager constantsManager;

    public IssueTypeValueMappingDefinition(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public String getJiraFieldId() {
        return "issuetype";
    }

    public Collection<ValueMappingEntry> getTargetValues() {
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)this.constantsManager.getAllIssueTypeObjects(), (Function)new AbstractValueMappingDefinition.IssueConstantToValueMapping()));
    }

    public boolean canBeBlank() {
        return false;
    }

    public boolean canBeCustom() {
        return false;
    }

    public boolean canBeImportedAsIs() {
        return false;
    }

    public String getExternalFieldId() {
        return KIND;
    }

    public String getDescription() {
        return null;
    }

    public Set<String> getDistinctValues() {
        return ImmutableSet.of((Object)BUG, (Object)ENHANCEMENT, (Object)PROPOSAL, (Object)TASK);
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        return ImmutableList.of((Object)new ValueMappingEntry(BUG, Integer.valueOf(1)), (Object)new ValueMappingEntry(ENHANCEMENT, Integer.valueOf(4)), (Object)new ValueMappingEntry(PROPOSAL, Integer.valueOf(2)), (Object)new ValueMappingEntry(TASK, Integer.valueOf(3)));
    }

    public boolean isMandatory() {
        return false;
    }
}

