/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImportProcessBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterClient;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class BitbucketImporterDataBean
extends AbstractDataBean<BitbucketImporterConfigBean> {
    private static final String UNUSED_USERS_GROUP = "bitbucket-import-unused-users";
    private final BitbucketImporterClient client;
    private final BitbucketImportProcessBean importProcessBean;

    protected BitbucketImporterDataBean(BitbucketImportProcessBean importProcessBean) {
        super((AbstractConfigBean2)((BitbucketImporterConfigBean)importProcessBean.getConfigBean()));
        this.importProcessBean = importProcessBean;
        this.client = ((BitbucketImporterConfigBean)this.configBean).getBitbucketImporterClient();
    }

    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> externalProjects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    public Set<ExternalUser> getAllUsers(ImportLogger importLogger) {
        return Sets.newHashSet(this.client.getUsers());
    }

    public Set<ExternalProject> getAllProjects(ImportLogger importLogger) {
        return Sets.newHashSet(this.client.getAllProjects(importLogger));
    }

    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        return Sets.newHashSet(this.client.getVersions(externalProject.getId(), importLogger));
    }

    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return Sets.newHashSet(this.client.getComponents(externalProject.getId(), importLogger));
    }

    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.client.getIssuesIterator(externalProject, importLogger);
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        return externalIssue.getAttachments();
    }

    public void cleanUp() {
        this.importProcessBean.cleanup();
        this.client.cleanup();
    }

    public String getIssueKeyRegex() {
        return "#(\\d+)";
    }

    public Collection<ExternalLink> getLinks(ImportLogger importLogger) {
        return this.client.getLinks(this.getSelectedProjects(importLogger), importLogger);
    }

    public long getTotalIssues(Set<ExternalProject> externalProjects, ImportLogger importLogger) {
        return this.client.getTotalIssues(this.getSelectedProjects(importLogger), importLogger);
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }
}

