/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Cacheable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class HashDecay
extends Hashtable
implements Runnable {
    private static volatile int THREAD_COUNTER = 1;
    public static final long MIN_DELAY = 0L;
    private final long delay;
    private Thread decay_thread;
    private boolean runForever = true;
    private static Vector started = new Vector();

    public HashDecay() {
        this(0L);
    }

    public HashDecay(long delay) {
        this.delay = 0L > delay ? 0L : delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void run() {
        while (this.runForever) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.decay();
        }
    }

    private synchronized void decay() {
        long now = new Date().getTime();
        Enumeration en = this.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.delay < now - ((Cacheable)this.get(key)).getUpdateTime()) continue;
            super.remove(key);
        }
    }

    public Object put(Object key, Object value) {
        if (!(value instanceof Cacheable)) {
            return null;
        }
        return this.put(key, (Cacheable)value);
    }

    public Object put(Object key, Cacheable value) {
        value.refreshUpdateTime();
        super.remove(key);
        Cacheable obj = super.put(key, value);
        return obj;
    }

    public void start() {
        if (null != this.decay_thread) {
            return;
        }
        this.runForever = true;
        this.decay_thread = new Thread((Runnable)this, "perforce-HashDecay-" + THREAD_COUNTER++);
        this.decay_thread.setDaemon(true);
        this.decay_thread.start();
        started.addElement(this);
    }

    public void stop() {
        this.runForever = false;
        if (null == this.decay_thread) {
            return;
        }
        try {
            this.decay_thread.interrupt();
            this.decay_thread.join(100L);
        }
        catch (InterruptedException ex) {
            this.decay_thread.stop();
        }
        catch (SecurityException ex) {
            this.decay_thread.stop();
        }
    }

    public static void stopAll() {
        Enumeration en = started.elements();
        while (en.hasMoreElements()) {
            HashDecay hd = (HashDecay)en.nextElement();
            hd.stop();
        }
    }

    static {
        started = new Vector();
    }
}

