/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.springmvc.interceptor;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class SystemAdminAuthorisationInterceptor
extends HandlerInterceptorAdapter {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final ApplicationProperties applicationProperties;

    public SystemAdminAuthorisationInterceptor(UserManager userManager, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.applicationProperties = applicationProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean isSystemAdmin = this.userManager.isSystemAdmin(this.userManager.getRemoteUsername(request));
        if (!isSystemAdmin) {
            String requestPath = request.getRequestURI().substring(request.getContextPath().length());
            request.getSession().setAttribute("seraph_originalurl", (Object)requestPath);
            response.sendRedirect(this.getRelativeLoginUrl(request.getContextPath(), requestPath));
        }
        return isSystemAdmin;
    }

    private String getRelativeLoginUrl(String contextPath, String originalRequestPath) throws URISyntaxException {
        String loginUri = this.loginUriProvider.getLoginUri(new URI(originalRequestPath)).toString();
        if (!loginUri.startsWith(this.applicationProperties.getBaseUrl())) {
            return loginUri;
        }
        if (!(loginUri = loginUri.substring(this.applicationProperties.getBaseUrl().length())).startsWith("/")) {
            loginUri = "/" + loginUri;
        }
        return contextPath + loginUri;
    }
}

