/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.dbexporter.importer;

import com.atlassian.dbexporter.node.NodeParser;
import com.google.common.base.Preconditions;

public final class ImporterUtils {
    private ImporterUtils() {
    }

    public static void checkStartNode(NodeParser node, String nodeName) {
        ImporterUtils.checkNode(node, nodeName, !node.isClosed());
    }

    public static boolean isNodeNotClosed(NodeParser node, String nodeName) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)nodeName);
        return !node.isClosed() && nodeName.equals(node.getName());
    }

    public static void checkEndNode(NodeParser node, String nodeName) {
        ImporterUtils.checkNode(node, nodeName, node.isClosed());
    }

    private static void checkNode(NodeParser node, String nodeName, boolean closed) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkState((boolean)node.getName().equals(nodeName), (String)"%s is not named '%s' as expected", (Object[])new Object[]{node, nodeName});
        Preconditions.checkState((boolean)closed, (String)"%s is not closed (%s) as expected", (Object[])new Object[]{node, closed});
    }
}

