/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import net.java.ao.ActiveObjectsException;
import net.java.ao.EntityManager;
import net.java.ao.sql.SqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActiveObjectsSqlException
extends ActiveObjectsException {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Database database;
    private Driver driver;

    public ActiveObjectsSqlException(EntityManager entityManager, SQLException cause) {
        super(cause);
        this.getInformation(entityManager);
    }

    public SQLException getSqlException() {
        return (SQLException)this.getCause();
    }

    @Override
    public String getMessage() {
        return "There was a SQL exception thrown by the Active Objects library:\n" + this.database + "\n" + this.driver + "\n\n" + super.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInformation(EntityManager entityManager) {
        Connection connection = null;
        try {
            connection = entityManager.getProvider().getConnection();
            if (connection != null && !connection.isClosed()) {
                DatabaseMetaData metaData = connection.getMetaData();
                this.database = ActiveObjectsSqlException.getDatabase(metaData);
                this.driver = ActiveObjectsSqlException.getDriver(metaData);
            }
        }
        catch (SQLException e) {
            this.logger.debug("Could not load database connection meta data", (Throwable)e);
        }
        finally {
            SqlUtils.closeQuietly(connection);
        }
    }

    private static Database getDatabase(DatabaseMetaData metaData) throws SQLException {
        return new Database(ActiveObjectsSqlException.getDatabaseName(metaData), ActiveObjectsSqlException.getDatabaseVersion(metaData), ActiveObjectsSqlException.getDatabaseMinorVersion(metaData), ActiveObjectsSqlException.getDatabaseMajorVersion(metaData));
    }

    private static Driver getDriver(DatabaseMetaData metaData) throws SQLException {
        return new Driver(ActiveObjectsSqlException.getDriverName(metaData), ActiveObjectsSqlException.getDriverVersion(metaData));
    }

    private static String getDatabaseName(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDatabaseProductName();
    }

    private static String getDatabaseVersion(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDatabaseProductVersion();
    }

    private static String getDatabaseMinorVersion(DatabaseMetaData metaData) throws SQLException {
        return String.valueOf(metaData.getDatabaseMinorVersion());
    }

    private static String getDatabaseMajorVersion(DatabaseMetaData metaData) throws SQLException {
        return String.valueOf(metaData.getDatabaseMajorVersion());
    }

    private static String getDriverName(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDriverName();
    }

    private static String getDriverVersion(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDriverVersion();
    }

    private static final class Driver {
        public final String name;
        public final String version;

        public Driver(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return "Driver:\n\t- name:" + this.name + "\n\t- version:" + this.version;
        }
    }

    private static final class Database {
        public final String name;
        public final String version;
        public final String minorVersion;
        public final String majorVersion;

        public Database(String name, String version, String minorVersion, String majorVersion) {
            this.name = name;
            this.version = version;
            this.minorVersion = minorVersion;
            this.majorVersion = majorVersion;
        }

        public String toString() {
            return "Database:\n\t- name:" + this.name + "\n\t- version:" + this.version + "\n\t- minor version:" + this.minorVersion + "\n\t- major version:" + this.majorVersion;
        }
    }
}

