/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service.rest;

import com.atlassian.annotations.Internal;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.ConfluencePage;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSearchResult;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSpace;
import com.atlassian.jira.plugin.link.confluence.cql.ConfluenceContentType;
import com.atlassian.jira.plugin.link.confluence.cql.ConfluenceCqlBuilder;
import com.atlassian.jira.plugin.link.confluence.service.rest.ConfluenceRestContentResponseHandler;
import com.atlassian.jira.plugin.link.confluence.service.rest.ConfluenceRestSearchResponseHandler;
import com.atlassian.jira.plugin.link.confluence.service.rest.ConfluenceRestService;
import com.atlassian.jira.plugin.link.confluence.service.rpc.ConfluenceRpcService;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ConfluenceRestServiceImpl
implements ConfluenceRestService,
CachingComponent {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRestServiceImpl.class);
    private static final String CONTENT_URL = "rest/api/content/%s";
    private final ConfluenceRpcService confluenceRpcService;
    private final Cache<ApplicationId, Boolean> restSearchSupported;

    @Autowired
    public ConfluenceRestServiceImpl(ConfluenceRpcService confluenceRpcService, @ComponentImport CacheManager cacheManager) {
        this.confluenceRpcService = confluenceRpcService;
        this.restSearchSupported = cacheManager.getCache(ConfluenceRestServiceImpl.class.getName() + ".restSearchSupported", null, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(50).build());
    }

    @EventListener
    public void onClearCacheEvent(ClearCacheEvent e) {
        log.debug("Clearing rest support cache because clear cache requested", (Object)e);
        this.clearCache();
    }

    @EventListener
    public void onAppLinkIdChangeEvent(ApplicationLinksIDChangedEvent e) {
        log.debug("Clearing rest support cache because applink ID has changed", (Object)e);
        this.clearCache();
    }

    @Internal
    public void clearCache() {
        this.restSearchSupported.removeAll();
    }

    @Override
    public RemoteResponse<ConfluencePage> getPage(ApplicationLink applicationLink, String pageId) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, String.format(CONTENT_URL, pageId));
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new ConfluenceRestContentResponseHandler());
    }

    @Override
    public RemoteResponse<List<ConfluenceSpace>> getSpaces(ApplicationLink applicationLink) throws CredentialsRequiredException, ResponseException {
        return this.confluenceRpcService.getSpaces(applicationLink);
    }

    @Override
    public RemoteResponse<List<ConfluenceSearchResult>> search(ApplicationLink applicationLink, String query, int maxResults, @Nullable String spaceKey) throws CredentialsRequiredException, ResponseException {
        Boolean isSupported = (Boolean)this.restSearchSupported.get((Object)applicationLink.getId(), () -> true);
        if (isSupported.booleanValue()) {
            RemoteResponse<List<ConfluenceSearchResult>> conf59searchResults = this.attemptSearchForConfluence_5_9_up(applicationLink, query, maxResults, spaceKey);
            if (conf59searchResults.getStatusCode() != 404) {
                return conf59searchResults;
            }
            log.warn(String.format("Remote Confluence instance '%s' does not support REST endpoint for search", applicationLink.getId()));
            this.restSearchSupported.put((Object)applicationLink.getId(), (Object)false);
        }
        return this.confluenceRpcService.search(applicationLink, query, maxResults, spaceKey);
    }

    private RemoteResponse<List<ConfluenceSearchResult>> attemptSearchForConfluence_5_9_up(ApplicationLink applicationLink, String query, int maxResults, @Nullable String spaceKey) throws CredentialsRequiredException, ResponseException {
        ConfluenceCqlBuilder cqlBuilder = new ConfluenceCqlBuilder();
        String cqlQuery = cqlBuilder.excludeContentType(ConfluenceContentType.ATTACHMENT).excludeContentType(ConfluenceContentType.COMMENT).textQuery(query).spaceKey(spaceKey).build();
        UrlBuilder builder = new UrlBuilder("rest/api/search");
        builder.addParameter("cql", cqlQuery);
        builder.addParameter("limit", (Object)maxResults);
        builder.addParameter("expand", "body");
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            Map cqlContextMap = MapBuilder.build((Object)"spaceKey", (Object)spaceKey);
            JSONObject cqlContext = new JSONObject(cqlContextMap);
            builder.addParameter("cqlcontext", cqlContext.toString());
        }
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, builder.asUrlString());
        return (RemoteResponse)request.execute((ApplicationLinkResponseHandler)new ConfluenceRestSearchResponseHandler());
    }
}

