/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service.rest;

import com.atlassian.jira.plugin.link.confluence.ConfluenceSearchResult;
import com.atlassian.jira.plugin.link.confluence.service.rest.AbstractConfluenceRestCollectionResponseHandler;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceRestSearchResponseHandler
extends AbstractConfluenceRestCollectionResponseHandler<ConfluenceSearchResult> {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRestSearchResponseHandler.class);

    @Override
    ConfluenceSearchResult processResult(JSONObject jsonObject) {
        ConfluenceSearchResult.ConfluenceSearchResultBuilder builder = new ConfluenceSearchResult.ConfluenceSearchResultBuilder();
        try {
            if (jsonObject.has("entityType")) {
                String entityType = jsonObject.getString("entityType");
                JSONObject content = jsonObject.getJSONObject(entityType);
                builder.id(content.getString("id"));
                builder.type(content.getString("type"));
                String url = this.fullConfluenceUrl(content.getJSONObject("_links"));
                builder.url(url);
                String titleContent = ConfluenceRestSearchResponseHandler.mark(jsonObject.getString("title"));
                builder.titleContent(titleContent);
                builder.title(ConfluenceRestSearchResponseHandler.stripHtml(titleContent));
                String excerptContent = ConfluenceRestSearchResponseHandler.mark(jsonObject.getString("excerpt"));
                builder.excerptContent(excerptContent);
                builder.excerpt(ConfluenceRestSearchResponseHandler.stripHtml(excerptContent));
            }
        }
        catch (JSONException e) {
            log.debug("Error processing JSON object for search result", (Object)jsonObject, (Object)e);
        }
        return builder.build();
    }

    private static String mark(String content) {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            return Jsoup.clean((String)content, (Whitelist)Whitelist.simpleText()).replace("@@@endhl@@@", "</mark>").replace("@@@hl@@@", "<mark>");
        }
        return "";
    }

    private static String stripHtml(String content) {
        return Jsoup.parseBodyFragment((String)content).text();
    }
}

