/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.ConfluenceGlobalId;
import com.atlassian.jira.plugin.link.confluence.ConfluencePage;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceGlobalIdFactory;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceIssueLinkDecoratingService;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceRemoteServiceStrategyFactory;
import com.atlassian.jira.util.BaseUrlSwapper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceIssueLinkDecoratingServiceImpl
implements ConfluenceIssueLinkDecoratingService {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceIssueLinkDecoratingServiceImpl.class);
    private static final String FAVICON_PATH = "/images/icons/favicon.png";
    private static final String CONFLUENCE_SRC = "src";
    private final ConfluenceRemoteServiceStrategyFactory strategyFactory;
    private final ConfluenceGlobalIdFactory confluenceGlobalIdFactory;

    @Autowired
    public ConfluenceIssueLinkDecoratingServiceImpl(ConfluenceRemoteServiceStrategyFactory confluenceRemoteServiceStrategyFactory, ConfluenceGlobalIdFactory confluenceGlobalIdFactory) {
        this.strategyFactory = confluenceRemoteServiceStrategyFactory;
        this.confluenceGlobalIdFactory = confluenceGlobalIdFactory;
    }

    @Override
    public RemoteIssueLink decorate(RemoteIssueLink remoteIssueLink) throws CredentialsRequiredException, IOException, PermissionException, NotFoundException {
        if (!RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE.equals(remoteIssueLink.getApplicationType())) {
            throw new IllegalArgumentException("Remote link is not to Confluence");
        }
        ConfluenceGlobalId globalId = this.confluenceGlobalIdFactory.create(remoteIssueLink);
        try {
            RemoteResponse<ConfluencePage> response = this.strategyFactory.get().getPage(globalId.getApplicationLink(), globalId.getPageId());
            log.debug("Received the following response for Confluence page {}: {}", (Object)globalId.getPageId(), response);
            return ConfluenceIssueLinkDecoratingServiceImpl.handleResponse(response, remoteIssueLink, globalId.getApplicationLink());
        }
        catch (ResponseException e) {
            throw new IOException("Failed to load Confluence Page from remote server", e);
        }
    }

    private static RemoteIssueLink handleResponse(RemoteResponse<ConfluencePage> response, RemoteIssueLink remoteIssueLink, ApplicationLink appLink) throws ResponseException, CredentialsRequiredException, PermissionException {
        if (!response.isSuccessful()) {
            switch (response.getStatusCode()) {
                case 401: {
                    throw new CredentialsRequiredException((AuthorisationURIGenerator)appLink.createAuthenticatedRequestFactory(), "Token expired");
                }
                case 403: {
                    throw new ResponseException("Confluence remote API is disabled");
                }
                case 404: 
                case 410: {
                    throw new NotFoundException("Either not allowed to view that content, or it does not exist.");
                }
            }
            ConfluenceIssueLinkDecoratingServiceImpl.checkErrorMessages(response);
            throw new ResponseException(response.toString());
        }
        String iconUrl = new UrlBuilder(appLink.getDisplayUrl().toASCIIString()).addPathUnsafe(FAVICON_PATH).asUrlString();
        ConfluencePage confluencePage = (ConfluencePage)response.getEntity();
        return new RemoteIssueLinkBuilder(remoteIssueLink).url(ConfluenceIssueLinkDecoratingServiceImpl.buildPageUrlWithSrc(BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)confluencePage.getUrl(), (ApplicationLink)appLink), "jira")).title(confluencePage.getTitle()).iconUrl(iconUrl).applicationName(appLink.getName()).build();
    }

    private static void checkErrorMessages(RemoteResponse<?> response) throws PermissionException {
        if (response.containsErrorWithText(new String[]{"NotPermittedException"})) {
            throw new PermissionException();
        }
    }

    private static String buildPageUrlWithSrc(String pageUrl, String param) {
        return new UrlBuilder(pageUrl).addParameter(CONFLUENCE_SRC, param).asUrlString();
    }
}

