/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSearchResult;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSpace;
import com.atlassian.jira.plugin.link.confluence.rest.ConfluenceApplicationLinksBean;
import com.atlassian.jira.plugin.link.confluence.rest.ConfluenceSearchResponseBean;
import com.atlassian.jira.plugin.link.confluence.rest.ConfluenceSpaceResponseBean;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceRemoteServiceStrategyFactory;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.util.BaseUrlSwapper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.MoreObjects;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousAllowed
@Path(value="confluence")
public class ConfluenceResource {
    static final int CONF_DEFAULT_MAX = 25;
    private final ConfluenceRemoteServiceStrategyFactory strategyFactory;
    private final ApplicationLinkService applicationLinkService;
    private final JiraBaseUrls jiraBaseUrls;
    private final I18nHelper i18nBean;

    @Autowired
    public ConfluenceResource(ConfluenceRemoteServiceStrategyFactory confluenceRemoteServiceStrategyFactory, @ComponentImport ApplicationLinkService applicationLinkService, @ComponentImport JiraBaseUrls jiraBaseUrls, @ComponentImport I18nHelper i18nBean) {
        this.strategyFactory = confluenceRemoteServiceStrategyFactory;
        this.applicationLinkService = applicationLinkService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.i18nBean = i18nBean;
    }

    @GET
    @Path(value="/space")
    @Produces(value={"application/json"})
    public Response getSpaces(@QueryParam(value="query") String query, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="appId") String appId) {
        return (Response)this.getApplink(appId).left().on(appLink -> {
            try {
                Integer limit = (Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)0x100000);
                PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)limit);
                RemoteResponse<List<ConfluenceSpace>> response = this.strategyFactory.get().getSpaces((ApplicationLink)appLink);
                if (!response.isSuccessful()) {
                    return this.handleUnsuccessfulResponse(response);
                }
                Page results = Pages.toPage((Iterable)((Iterable)response.getEntity()), (PageRequest)pageRequest);
                String spaceSelfLink = this.getSpaceSelfLink(query, pageRequest, appId);
                PageBean bean = PageBean.from((PageRequest)pageRequest, (Page)results).setLinks(spaceSelfLink, pageRequest.getLimit()).build(this::makeSpace);
                return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
            }
            catch (CredentialsRequiredException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
            }
            catch (ResponseException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
            }
        });
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getSiteSearch(@QueryParam(value="query") String query, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="appId") String appId) {
        return (Response)this.getApplink(appId).left().on(appLink -> {
            try {
                Integer limit = (Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)25);
                PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)limit);
                RemoteResponse<List<ConfluenceSearchResult>> response = this.strategyFactory.get().search((ApplicationLink)appLink, query, limit, spaceKey);
                if (!response.isSuccessful()) {
                    return this.handleUnsuccessfulResponse(response);
                }
                Page results = Pages.toPage((Iterable)((Iterable)response.getEntity()), (PageRequest)pageRequest, result -> true, result -> new ConfluenceSearchResult.ConfluenceSearchResultBuilder((ConfluenceSearchResult)result).url(BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)result.getUrl(), (ApplicationLink)appLink)).build());
                String searchSelfLink = this.getSearchResultSelfLink(query, spaceKey, pageRequest, appId);
                PageBean bean = PageBean.from((PageRequest)pageRequest, (Page)results).setLinks(searchSelfLink, pageRequest.getLimit()).build(this::makeResult);
                return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
            }
            catch (CredentialsRequiredException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
            }
            catch (ResponseException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
            }
        });
    }

    @GET
    @Path(value="/applink")
    @Produces(value={"application/json"})
    public Response getApplicationLinks() {
        ConfluenceApplicationLinksBean bean = new ConfluenceApplicationLinksBean(this.getConfluenceAppLinks());
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    private Either<Response, ApplicationLink> getApplink(String appId) {
        ApplicationLink appLink = this.getConfluenceAppLink(appId);
        if (appLink == null) {
            ErrorCollection errors = ErrorCollection.of((String[])new String[]{this.i18nBean.getText("addconfluencelink.search.applink.not.found")});
            return Either.left((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.never()).build());
        }
        return Either.right((Object)appLink);
    }

    private ApplicationLink getConfluenceAppLink(String appId) {
        for (ApplicationLink appLink : this.getConfluenceAppLinks()) {
            if (!appLink.getId().get().equals(appId)) continue;
            return appLink;
        }
        return null;
    }

    private Iterable<ApplicationLink> getConfluenceAppLinks() {
        return this.applicationLinkService.getApplicationLinks(ConfluenceApplicationType.class);
    }

    private ConfluenceSpaceResponseBean.Space makeSpace(ConfluenceSpace space) {
        return new ConfluenceSpaceResponseBean.Space(space.getKey(), space.getName(), space.getType(), space.getUrl());
    }

    private ConfluenceSearchResponseBean.Result makeResult(ConfluenceSearchResult result) {
        return new ConfluenceSearchResponseBean.Result(result.getId(), result.getType(), result.getTitle(), result.getTitleContent(), result.getExcerpt(), result.getExcerptContent(), result.getUrl());
    }

    private String getSpaceSelfLink(String query, PageRequest pageRequest, String appId) {
        UriBuilder uri = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(ConfluenceResource.class).path("space");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            uri.queryParam("query", new Object[]{query});
        }
        uri.queryParam("startAt", new Object[]{String.valueOf(pageRequest.getStart())});
        uri.queryParam("maxResults", new Object[]{String.valueOf(pageRequest.getLimit())});
        uri.queryParam("appId", new Object[]{appId});
        return uri.build(new Object[0]).toString();
    }

    private String getSearchResultSelfLink(String query, String spaceKey, PageRequest pageRequest, String appId) {
        UriBuilder uri = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(ConfluenceResource.class).path("search");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            uri.queryParam("query", new Object[]{query});
        }
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            uri.queryParam("spaceKey", new Object[]{spaceKey});
        }
        uri.queryParam("startAt", new Object[]{String.valueOf(pageRequest.getStart())});
        uri.queryParam("maxResults", new Object[]{String.valueOf(pageRequest.getLimit())});
        uri.queryParam("appId", new Object[]{appId});
        return uri.build(new Object[0]).toString();
    }

    private Response handleUnsuccessfulResponse(RemoteResponse<?> response) {
        ErrorCollection errors = ErrorCollection.of((String[])new String[]{response.getStatusText()});
        if (response.hasErrors()) {
            errors.addErrorCollection(response.getErrors());
        }
        return Response.status((int)response.getStatusCode()).entity((Object)errors).cacheControl(CacheControl.never()).build();
    }
}

