/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.cql;

import com.atlassian.jira.plugin.link.confluence.Builder;
import com.atlassian.jira.plugin.link.confluence.cql.ConfluenceContentType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ConfluenceCqlBuilder
implements Builder<String> {
    private String textQuery;
    private String spaceKey;
    private final List<String> excludedContentTypes = Lists.newArrayList();

    public ConfluenceCqlBuilder textQuery(String textQuery) {
        this.textQuery = textQuery;
        return this;
    }

    public ConfluenceCqlBuilder spaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
        return this;
    }

    public ConfluenceCqlBuilder excludeContentType(ConfluenceContentType contentType) {
        this.excludedContentTypes.add(contentType.getType());
        return this;
    }

    @Override
    public String build() {
        return this.constructCqlQuery(this.textQuery, this.spaceKey, this.excludedContentTypes);
    }

    @Override
    public void clear() {
        this.textQuery = null;
        this.spaceKey = null;
        this.excludedContentTypes.clear();
    }

    private String constructCqlQuery(String textQuery, @Nullable String spaceKey, @Nonnull List<String> excludeContentTypes) {
        ArrayList cqlTerms = Lists.newArrayList();
        cqlTerms.add(String.format("text ~ \"%s\"", this.esc(textQuery)));
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            cqlTerms.add(String.format("space = \"%s\"", this.esc(spaceKey)));
        }
        if (!excludeContentTypes.isEmpty()) {
            cqlTerms.add(String.format("type NOT IN (%s)", String.join((CharSequence)",", excludeContentTypes)));
        }
        return String.join((CharSequence)" AND ", cqlTerms);
    }

    private String esc(@Nonnull String val) {
        return StringUtils.replace((String)val, (String)"\"", (String)"\\\"");
    }
}

