/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.ConfluenceApplicationLinks;
import com.atlassian.jira.plugin.link.confluence.ConfluencePageUrl;
import com.atlassian.jira.plugin.link.confluence.ConfluenceRemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.confluence.service.ConfluencePageService;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.issue.AbstractIssueLinkAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkConfluencePage
extends AbstractIssueLinkAction {
    private final ConfluenceApplicationLinks confluenceAppLinks;
    private final ConfluencePageService confluencePageService;
    private String pageUrl;
    private ApplicationLink appLink;
    private Collection<ApplicationLink> appLinks;

    @Autowired
    public LinkConfluencePage(@ComponentImport SubTaskManager subTaskManager, @ComponentImport FieldScreenRendererFactory fieldScreenRendererFactory, @ComponentImport FieldManager fieldManager, @ComponentImport ProjectRoleManager projectRoleManager, @ComponentImport CommentService commentService, @ComponentImport UserUtil userUtil, @ComponentImport RemoteIssueLinkService remoteIssueLinkService, @ComponentImport EventPublisher eventPublisher, @ComponentImport IssueEventManager issueEventManager, @ComponentImport IssueEventBundleFactory issueEventBundleFactory, ConfluenceApplicationLinks confluenceAppLinks, ConfluencePageService confluencePageService) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil, remoteIssueLinkService, eventPublisher, issueEventManager, issueEventBundleFactory);
        this.confluenceAppLinks = confluenceAppLinks;
        this.confluencePageService = confluencePageService;
    }

    public boolean isValidToView() {
        return super.isValidToView() && !this.getAppLinks().isEmpty();
    }

    protected void doValidation() {
        super.doValidation();
        this.validateUrl(this.pageUrl);
        if (this.hasAnyErrors()) {
            return;
        }
        this.pageUrl = ConfluencePageUrl.build(this.pageUrl, this.appLink).getUrlRebasedToRpcUrl();
        String pageId = this.getPageId(this.pageUrl, this.appLink);
        if (!this.hasAnyErrors() && pageId == null) {
            this.addErrorMessage(this.getText("addconfluencelink.error.pageid.notfound"));
        }
        if (!this.hasAnyErrors()) {
            RemoteIssueLink remoteIssueLink = new ConfluenceRemoteIssueLinkBuilder().build(this.appLink, pageId, this.getIssue().getLong("id"));
            this.validationResult = this.remoteIssueLinkService.validateCreate(this.getLoggedInUser(), remoteIssueLink);
            if (!this.validationResult.isValid()) {
                this.mapErrors(this.validationResult.getErrorCollection());
                this.addErrorCollection(this.validationResult.getErrorCollection());
            }
        }
    }

    private void mapErrors(ErrorCollection errorCollection) {
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            if ("globalId".equals(entry.getKey())) {
                errorCollection.addErrorMessage(this.getText("addconfluencelink.error.duplicate"));
                continue;
            }
            errorCollection.addErrorMessage((String)entry.getValue());
        }
    }

    private void validateUrl(String pageUrl) {
        URI pageUri;
        if (StringUtils.isBlank((String)pageUrl)) {
            this.addError("pageUrl", this.getText("addconfluencelink.error.url.required"));
            return;
        }
        try {
            pageUri = new URI(pageUrl);
        }
        catch (URISyntaxException e) {
            this.addError("pageUrl", this.getText("addconfluencelink.error.url.invalid"));
            return;
        }
        if (!this.isThereApplicationLinkFor(pageUri)) {
            this.addErrorMessage(this.getText("addconfluencelink.error.no.matching.app.link", "<a href='#' class='confluence-search-trigger'>", "</a>"));
        }
    }

    private boolean isThereApplicationLinkFor(URI pageUri) {
        this.appLink = (ApplicationLink)this.confluenceAppLinks.forPage(pageUri).getOrNull();
        return this.appLink != null;
    }

    private String getPageId(String pageUrl, ApplicationLink appLink) {
        try {
            RemoteResponse<String> response = this.confluencePageService.getPageId(appLink, pageUrl);
            if (response.isSuccessful()) {
                return (String)response.getEntity();
            }
            switch (response.getStatusCode()) {
                case 403: {
                    this.addErrorMessage(this.getText("addconfluencelink.error.page.forbidden"));
                    break;
                }
                case 401: {
                    this.handleCredentialsRequired();
                    break;
                }
                default: {
                    this.addErrorMessage(this.getText("addconfluencelink.error.pageid.notfound"));
                    this.log.error((Object)("Invalid response from getting the pageId: " + response.getStatusCode() + ": " + response.getStatusText()));
                    break;
                }
            }
        }
        catch (CredentialsRequiredException e) {
            this.handleCredentialsRequired();
        }
        catch (ResponseException e) {
            this.addErrorMessage(this.getText("addconfluencelink.error.pageid.notfound"));
            this.log.error((Object)("Invalid response from getting the pageId: " + e.getMessage()));
        }
        return null;
    }

    public String doDefault() throws Exception {
        this.pageUrl = "http://";
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.createLink();
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
            return "error";
        }
        this.createAndDispatchComment();
        return this.returnComplete(this.getRedirectUrl());
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getAppId() {
        if (this.appLink != null) {
            return this.appLink.getId().get();
        }
        return "";
    }

    @HtmlSafe
    public Collection<String> getFlushedErrorMessages() {
        return super.getFlushedErrorMessages();
    }

    public Collection<ApplicationLink> getAppLinks() {
        if (this.appLinks == null) {
            this.appLinks = this.confluenceAppLinks.getAppLinks();
        }
        return this.appLinks;
    }
}

