/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceGlobalIdFactoryImpl;
import com.atlassian.jira.util.UrlBuilder;

public class ConfluenceRemoteIssueLinkBuilder {
    private static final String TITLE = "Wiki Page";
    private static final String RELATIONSHIP = "Wiki Page";

    public RemoteIssueLink build(ApplicationLink appLink, String pageId, Long issueId) {
        String globalId = ConfluenceGlobalIdFactoryImpl.encode(appLink.getId(), pageId);
        return new RemoteIssueLinkBuilder().issueId(issueId).url(ConfluenceRemoteIssueLinkBuilder.buildPageUrl(appLink, pageId)).title("Wiki Page").globalId(globalId).relationship("Wiki Page").applicationType(RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE).applicationName(appLink.getName()).build();
    }

    private static String buildPageUrl(ApplicationLink appLink, String pageId) {
        return new UrlBuilder(appLink.getRpcUrl().toASCIIString()).addPathUnsafe("pages/viewpage.action").addParameter("pageId", pageId).asUrlString();
    }
}

