/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jira.util.UriMatcher;
import java.net.URI;
import java.net.URISyntaxException;

public class ConfluencePageUrl {
    private final URI pageUri;
    private final ApplicationLink appLink;

    private ConfluencePageUrl(URI pageUri, ApplicationLink appLink) {
        this.pageUri = pageUri;
        this.appLink = appLink;
    }

    public static ConfluencePageUrl build(String pageUriAsString, ApplicationLink appLink) {
        URI pageUri;
        try {
            pageUri = new URI(pageUriAsString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (!ConfluencePageUrl.isUriValidForAppLink(pageUri, appLink)) {
            throw new IllegalArgumentException("The page uri must be based on either the application link's display uri or the application link's rpc uri");
        }
        return new ConfluencePageUrl(pageUri, appLink);
    }

    private static boolean isUriValidForAppLink(URI pageUri, ApplicationLink appLink) {
        return UriMatcher.isBaseEqual((URI)appLink.getDisplayUrl(), (URI)pageUri) || UriMatcher.isBaseEqual((URI)appLink.getRpcUrl(), (URI)pageUri);
    }

    public String getUrlRebasedToRpcUrl() {
        String urlAsString = this.pageUri.toASCIIString();
        if (UriMatcher.isBaseEqual((URI)this.appLink.getDisplayUrl(), (URI)this.pageUri)) {
            return urlAsString.replace(this.appLink.getDisplayUrl().toASCIIString(), this.appLink.getRpcUrl().toASCIIString());
        }
        return urlAsString;
    }
}

