/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.UriMatcher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceApplicationLinks {
    private final ApplicationLinkService applicationLinkService;

    @Autowired
    public ConfluenceApplicationLinks(@ComponentImport ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public Collection<ApplicationLink> getAppLinks() {
        return ImmutableList.copyOf((Iterable)this.applicationLinkService.getApplicationLinks(ConfluenceApplicationType.class));
    }

    public Option<ApplicationLink> forPage(URI pageUri) {
        List<ApplicationLink> candidateAppLinks = this.getCandidateAppLinksForPage(pageUri);
        if (candidateAppLinks.isEmpty()) {
            return Option.none();
        }
        for (ApplicationLink matchingAppLink : candidateAppLinks) {
            if (!matchingAppLink.isPrimary()) continue;
            return Option.some((Object)matchingAppLink);
        }
        return Option.some((Object)candidateAppLinks.get(0));
    }

    private List<ApplicationLink> getCandidateAppLinksForPage(URI pageUri) {
        ArrayList<ApplicationLink> matchingAppLinks = new ArrayList<ApplicationLink>();
        for (ApplicationLink appLink : this.getAppLinks()) {
            if (!UriMatcher.isBaseEqual((URI)appLink.getDisplayUrl(), (URI)pageUri) && !UriMatcher.isBaseEqual((URI)appLink.getRpcUrl(), (URI)pageUri)) continue;
            matchingAppLinks.add(appLink);
        }
        return matchingAppLinks;
    }
}

