/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.helptips;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class HelpTipManager {
    private static final String KEY_NAMESPACE = "jira.user.suppressedTips.";
    private final UserPropertyManager userPropertyManager;

    @Inject
    public HelpTipManager(@ComponentImport UserPropertyManager userPropertyManager) {
        this.userPropertyManager = userPropertyManager;
    }

    public void dismissTip(ApplicationUser user, String id) {
        String tipId = this.getTipId(id);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(tipId, true);
    }

    public void undismissTip(ApplicationUser user, String id) {
        String tipId = this.getTipId(id);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        if (propertySet.exists(tipId)) {
            propertySet.remove(tipId);
        }
    }

    public Collection<String> getDismissedTips(ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        Collection results = propertySet.getKeys(KEY_NAMESPACE);
        return results.stream().map(from -> from.substring(KEY_NAMESPACE.length())).collect(Collectors.toList());
    }

    private String getTipId(String id) {
        return KEY_NAMESPACE + id;
    }
}

