/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.json;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.impl.json.CaseInsensitiveEnumDeserializer;
import com.atlassian.event.remote.impl.json.RemoteEventDeserializer;
import com.atlassian.event.remote.impl.json.RemoteEventJsonSerializer;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={JsonUtil.class})
public class DefaultJsonUtil
implements JsonUtil {
    public static final TypeReference<Collection<RemoteEvent>> REMOTE_EVENT_LIST_TYPE_REFERENCE = new TypeReference<Collection<RemoteEvent>>(){};
    private final ObjectMapper objectMapper;

    @Autowired
    public DefaultJsonUtil(final @ComponentImport InternalHostApplication host, RemoteEventDeserializer remoteEventDeserializer) {
        TypeFactory.defaultInstance().constructType(HashMap.class, (TypeBindings)null);
        TypeFactory.defaultInstance().constructType(LinkedHashMap.class, (TypeBindings)null);
        TypeFactory.defaultInstance().constructType(LRUMap.class, (TypeBindings)null);
        this.objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addDeserializers((Deserializers)new Deserializers.Base(){

                    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                        return new CaseInsensitiveEnumDeserializer(type);
                    }
                });
            }
        }.addDeserializer(RemoteEvent.class, (JsonDeserializer)remoteEventDeserializer)).registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                        if (RemoteEvent.class.isAssignableFrom(beanDesc.getBeanClass())) {
                            return new RemoteEventJsonSerializer((HostApplication)host, (BeanSerializerBase)serializer);
                        }
                        return super.modifySerializer(config, beanDesc, serializer);
                    }
                });
            }
        });
    }

    @Override
    public String write(Object o) throws IOException {
        return this.objectMapper.writeValueAsString(o);
    }

    @Override
    public Collection<RemoteEvent> readRemoteEvents(InputStream json) throws IOException {
        return Collections2.filter((Collection)((Collection)this.objectMapper.readValue(json, REMOTE_EVENT_LIST_TYPE_REFERENCE)), (Predicate)new Predicate<RemoteEvent>(){

            public boolean apply(@Nullable RemoteEvent input) {
                return input != null;
            }
        });
    }

    @Override
    public Collection<RemoteEvent> readRemoteEvents(String json) throws IOException {
        return Collections2.filter((Collection)((Collection)this.objectMapper.readValue(json, REMOTE_EVENT_LIST_TYPE_REFERENCE)), (Predicate)new Predicate<RemoteEvent>(){

            public boolean apply(@Nullable RemoteEvent input) {
                return input != null;
            }
        });
    }

    @Override
    public <T> T read(String json, Class<T> clazz) throws IOException {
        return (T)this.objectMapper.readValue(json, clazz);
    }

    @Override
    public <T> T read(InputStream json, Class<T> clazz) throws IOException {
        return (T)this.objectMapper.readValue(json, clazz);
    }
}

