/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.transformer.TimeUtils;
import com.google.common.base.Function;
import com.taskadapter.redmineapi.bean.TimeEntry;

public class WorklogTransformer
implements Function<TimeEntry, ExternalWorklog> {
    private final RedmineClient redmineClient;

    public WorklogTransformer(RedmineClient redmineClient) {
        this.redmineClient = redmineClient;
    }

    public ExternalWorklog apply(TimeEntry input) {
        ExternalWorklog externalWorklog = new ExternalWorklog();
        externalWorklog.setAuthor(this.redmineClient.getUserName(input.getUserId()));
        externalWorklog.setComment(input.getComment());
        if (input.getHours() != null) {
            externalWorklog.setTimeSpent(TimeUtils.convertFromHours(input.getHours()));
        }
        externalWorklog.setStartDate(input.getSpentOn());
        return externalWorklog;
    }
}

