/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.atlassian.jira.plugins.importer.redmine.UserOrGroup;
import com.atlassian.jira.plugins.importer.redmine.transformer.CommentsTransformer;
import com.atlassian.jira.plugins.importer.redmine.transformer.TimeUtils;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.Journal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class IssueTransformer
implements Function<Issue, ExternalIssue> {
    private static final String FIXED_RESOLUTION_ID = "1";
    private static final String ISSUE_CLOSED_ID = "6";
    private static final String ISSUE_RESOLVED_ID = "5";
    private final RedmineClient redmineClient;
    private final ValueMappingHelper valueMappingHelper;
    private final Function<CustomField, ExternalCustomFieldValue> fieldTransformer;
    private final CommentsTransformer commentsTransformer;
    private final boolean timeTrackingEnabled;
    private final ImportLogger logger;
    private final StatusManager statusManager;

    public IssueTransformer(RedmineConfigBean redmineConfigBean, boolean timeTrackingEnabled, ImportLogger logger, Function<CustomField, ExternalCustomFieldValue> fieldTransformer) {
        this.logger = logger;
        this.redmineClient = (RedmineClient)Preconditions.checkNotNull((Object)redmineConfigBean.getRedmineClient());
        this.valueMappingHelper = (ValueMappingHelper)Preconditions.checkNotNull((Object)redmineConfigBean.getValueMappingHelper());
        this.timeTrackingEnabled = timeTrackingEnabled;
        this.commentsTransformer = new CommentsTransformer(this.redmineClient);
        this.fieldTransformer = fieldTransformer;
        this.statusManager = (StatusManager)ComponentAccessor.getComponent(StatusManager.class);
    }

    public ExternalIssue apply(Issue input) {
        Optional<UserOrGroup> userOrGroup;
        ExternalIssue issue = new ExternalIssue();
        issue.setExternalId(String.valueOf(input.getId()));
        issue.setSummary(input.getSubject());
        issue.setDescription(input.getDescription());
        issue.setIssueType(input.getTracker() == null ? null : this.valueMappingHelper.getValueMapping("tracker", input.getTracker().getName()));
        issue.setStatus(this.valueMappingHelper.getValueMapping("status", input.getStatusName()));
        issue.setResolution(this.getResolutionState(issue));
        String mappedPriorityValue = this.valueMappingHelper.getValueMapping("priority", input.getPriorityText());
        issue.setPriority(StringUtils.isBlank((String)mappedPriorityValue) ? input.getPriorityText() : mappedPriorityValue);
        issue.setFixedVersions(input.getTargetVersion() == null ? null : Collections.singleton(input.getTargetVersion().getName()));
        issue.setOriginalEstimate(TimeUtils.convertFromHours(input.getEstimatedHours()));
        issue.setCreated(input.getCreatedOn());
        issue.setUpdated(input.getUpdatedOn());
        issue.setDuedate(input.getDueDate());
        issue.setReporter(this.redmineClient.getUserName(input.getAuthor()));
        issue.setComponents(input.getCategory() == null ? null : Lists.newArrayList((Object[])new String[]{input.getCategory().getName()}));
        if (CollectionUtils.isNotEmpty((Collection)input.getCustomFields())) {
            issue.setExternalCustomFieldValues(Lists.transform((List)Lists.newArrayList((Iterable)input.getCustomFields()), this.fieldTransformer));
        }
        if (CollectionUtils.isNotEmpty((Collection)input.getJournals())) {
            issue.setComments(Collections2.transform((Collection)Collections2.filter((Collection)input.getJournals(), (Predicate)new Predicate<Journal>(){

                public boolean apply(Journal input) {
                    return StringUtils.isNotBlank((String)input.getNotes());
                }
            }), (Function)this.commentsTransformer));
        }
        if (this.timeTrackingEnabled) {
            issue.setWorklogs((List)Lists.newArrayList(this.redmineClient.getWorklogForIssue(input.getId(), this.logger)));
        }
        if ((userOrGroup = this.redmineClient.getUserOrGroup(input.getAssignee())).isPresent()) {
            if (((UserOrGroup)userOrGroup.get()).isGroup()) {
                Integer groupId = ((UserOrGroup)userOrGroup.get()).getGroup().getId();
                Collection<String> usersInGroup = this.redmineClient.getAllUserLoginsForGroup(groupId);
                issue.setWatchers((List)Lists.newArrayList(usersInGroup));
                issue.setAssignee(null);
            } else {
                String login = ((UserOrGroup)userOrGroup.get()).getUser().getLogin();
                issue.setAssignee(login);
            }
        } else {
            issue.setAssignee(null);
        }
        return issue;
    }

    private String getResolutionState(ExternalIssue issue) {
        String status = issue.getStatus();
        Status statusObject = this.statusManager.getStatus(status);
        if (statusObject != null && statusObject.getStatusCategory() != null) {
            return "done".equals(statusObject.getStatusCategory().getKey()) ? FIXED_RESOLUTION_ID : null;
        }
        return null;
    }
}

