/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueRelation;
import java.util.ArrayList;
import java.util.Collection;

public class IssueToRelationsTransformer
implements Function<Issue, Collection<ExternalLink>> {
    public static final String PARENT_LINK_NAME = "parent";
    private final RedmineConfigBean configBean;

    public IssueToRelationsTransformer(RedmineConfigBean configBean) {
        this.configBean = configBean;
    }

    public Collection<ExternalLink> apply(Issue input) {
        ArrayList relations = Lists.newArrayList();
        for (IssueRelation issueRelation : input.getRelations()) {
            relations.add(new ExternalLink(this.configBean.getLinkMapping(issueRelation.getType()), issueRelation.getIssueId().toString(), issueRelation.getIssueToId().toString()));
        }
        if (input.getParentId() != null) {
            relations.add(new ExternalLink(this.configBean.getLinkMapping(PARENT_LINK_NAME), input.getId().toString(), input.getParentId().toString()));
        }
        return relations;
    }
}

