/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.taskadapter.redmineapi.bean.CustomField;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public abstract class CustomFieldTransformer {
    private CustomFieldTransformer() {
    }

    public static class CustomFieldDefinitionTransformer
    implements Function<CustomField, ExternalCustomField> {
        public ExternalCustomField apply(CustomField customField) {
            if (customField.isMultiple()) {
                return ExternalCustomField.createMultiSelect((String)String.valueOf(customField.getId()), (String)customField.getName());
            }
            return ExternalCustomField.createText((String)String.valueOf(customField.getId()), (String)customField.getName());
        }
    }

    public static class CustomFiledValueTransformer
    implements Function<CustomField, ExternalCustomFieldValue> {
        private final RedmineConfigBean redmineConfigBean;

        public CustomFiledValueTransformer(RedmineConfigBean redmineConfigBean) {
            this.redmineConfigBean = redmineConfigBean;
        }

        public ExternalCustomFieldValue apply(CustomField customField) {
            String customFieldName;
            String mapping = this.redmineConfigBean.getFieldMapping(String.valueOf(customField.getId()));
            String string = customFieldName = StringUtils.isNotEmpty((String)mapping) ? mapping : customField.getName();
            if (customField.isMultiple()) {
                return new ExternalCustomFieldValue(customFieldName, "com.atlassian.jira.plugin.system.customfieldtypes:multiselect", "com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher", (Object)ImmutableList.copyOf((Collection)customField.getValues()));
            }
            return new ExternalCustomFieldValue(customFieldName, "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher", (Object)customField.getValue());
        }
    }
}

