/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.UserOrGroup;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.taskadapter.redmineapi.bean.IssueCategory;

public class ComponentTransformer
implements Function<IssueCategory, ExternalComponent> {
    private final RedmineClient redmineClient;

    public ComponentTransformer(RedmineClient redmineClient) {
        this.redmineClient = redmineClient;
    }

    public ExternalComponent apply(IssueCategory input) {
        Optional<UserOrGroup> userOrGroup = this.redmineClient.getUserOrGroup(input.getAssignee());
        String lead = null;
        if (userOrGroup.isPresent() && !((UserOrGroup)userOrGroup.get()).isGroup() && ((UserOrGroup)userOrGroup.get()).getUser() != null) {
            lead = ((UserOrGroup)userOrGroup.get()).getUser().getLogin();
        }
        return new ExternalComponent(input.getName(), input.getId().toString(), lead, null);
    }
}

