/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.mapping;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class PriorityValueMappingDefinition
implements ValueMappingDefinition {
    public static final String PRIORITY_FIELD_NAME = "priority";
    private final ConstantsManager constantsManager;
    private final RedmineConfigBean redmineConfigBean;

    public PriorityValueMappingDefinition(RedmineConfigBean redmineConfigBean, ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
        this.redmineConfigBean = redmineConfigBean;
    }

    public String getJiraFieldId() {
        return PRIORITY_FIELD_NAME;
    }

    public Collection<ValueMappingEntry> getTargetValues() {
        return new ArrayList<ValueMappingEntry>(Collections2.transform((Collection)this.constantsManager.getPriorityObjects(), (Function)new AbstractValueMappingDefinition.IssueConstantToValueMapping()));
    }

    public boolean canBeBlank() {
        return false;
    }

    public boolean canBeCustom() {
        return true;
    }

    public boolean canBeImportedAsIs() {
        return true;
    }

    public String getExternalFieldId() {
        return PRIORITY_FIELD_NAME;
    }

    public String getDescription() {
        return null;
    }

    public Set<String> getDistinctValues() {
        return Sets.newHashSet(this.redmineConfigBean.getRedmineClient().getPriorities());
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Low", Integer.valueOf(5)), new ValueMappingEntry("Normal", Integer.valueOf(4)), new ValueMappingEntry("High", Integer.valueOf(3)), new ValueMappingEntry("Urgent", Integer.valueOf(2)), new ValueMappingEntry("Immediate", Integer.valueOf(1))}).build();
    }

    public boolean isMandatory() {
        return false;
    }
}

