/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.manager;

import com.atlassian.jira.plugins.importer.redmine.manager.CachedJiraRedmineManager;
import com.atlassian.jira.plugins.importer.redmine.manager.ComplementRedmineManager;
import com.atlassian.jira.plugins.importer.redmine.manager.ComplementRedmineManagerImpl;
import com.atlassian.jira.plugins.importer.redmine.manager.JiraRedmineManager;
import com.atlassian.jira.plugins.importer.redmine.manager.RedmineCommunicator;
import com.google.common.base.Preconditions;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.RedmineManagerFactory;
import com.taskadapter.redmineapi.TransportConfiguration;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;

public class JiraRedmineManagerFactory {
    private final String userName;
    private final String password;
    private final String redmineUri;

    public JiraRedmineManagerFactory(String redmineUri, String userName, String password) {
        this.redmineUri = redmineUri;
        this.password = password;
        this.userName = userName;
    }

    public JiraRedmineManager create() {
        final SystemDefaultHttpClient client = new SystemDefaultHttpClient();
        TransportConfiguration configuration = TransportConfiguration.create((HttpClient)client, (Runnable)new Runnable(){

            @Override
            public void run() {
                client.getConnectionManager().shutdown();
            }
        });
        RedmineManager redmineManager = RedmineManagerFactory.createWithUserAuth((String)((String)Preconditions.checkNotNull((Object)this.redmineUri)), (String)((String)Preconditions.checkNotNull((Object)this.userName)), (String)((String)Preconditions.checkNotNull((Object)this.password)), (TransportConfiguration)configuration);
        redmineManager.setObjectsPerPage(500);
        return new CachedJiraRedmineManager(redmineManager, this.createComplement());
    }

    private ComplementRedmineManager createComplement() {
        RedmineCommunicator redmineCommunicator = new RedmineCommunicator();
        redmineCommunicator.setCredentials(this.userName, this.password);
        return new ComplementRedmineManagerImpl(this.redmineUri, redmineCommunicator);
    }
}

