/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.manager;

import com.atlassian.jira.plugins.importer.redmine.CustomFieldDefinition;
import com.atlassian.jira.plugins.importer.redmine.UserOrGroup;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Optional;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public interface JiraRedmineManager {
    public LoginResult login() throws RedmineException;

    public void shutdown();

    public List<Project> getProjects() throws RedmineException;

    public List<Version> getVersions(String var1) throws RedmineException;

    public List<IssueCategory> getCategories(String var1) throws RedmineException;

    public List<IssueStatus> getStatuses() throws RedmineException;

    public List<Issue> getIssues(String var1) throws RedmineException;

    public User getUserById(Integer var1) throws RedmineException;

    public List<Tracker> getTrackers() throws RedmineException;

    public List<User> getUsers() throws RedmineException;

    public Issue getIssueById(String var1) throws RedmineException;

    public File getAttachmentContent(Attachment var1) throws RedmineException, IOException;

    public List<TimeEntry> getTimeEntriesForIssue(Integer var1) throws RedmineException;

    public Optional<Group> getGroupById(Integer var1) throws RedmineException;

    public Collection<User> getUsersForGroup(Integer var1) throws RedmineException;

    public Optional<UserOrGroup> getUserOrGroup(Integer var1) throws RedmineException;

    public Iterable<CustomFieldDefinition> getCustomFieldDefinitions() throws RedmineException;

    public static class LoginResult {
        private final ErrorCollection errorCollection;

        private LoginResult(ErrorCollection errorCollection) {
            this.errorCollection = errorCollection;
        }

        public boolean isValid() {
            return !this.errorCollection.hasAnyErrors();
        }

        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public static LoginResult ok() {
            return new LoginResult((ErrorCollection)new SimpleErrorCollection());
        }

        public static LoginResult error(String errorMessage) {
            SimpleErrorCollection collection = new SimpleErrorCollection();
            collection.addErrorMessage(errorMessage);
            return new LoginResult((ErrorCollection)collection);
        }
    }
}

