/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.manager;

import com.atlassian.jira.plugins.importer.redmine.CustomFieldDefinition;
import com.atlassian.jira.plugins.importer.redmine.manager.ComplementRedmineManager;
import com.atlassian.jira.plugins.importer.redmine.manager.RedmineCommunicator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplementRedmineManagerImpl
implements ComplementRedmineManager {
    private final Logger log = LoggerFactory.getLogger(ComplementRedmineManagerImpl.class);
    public static final String CHARSET = "UTF-8";
    private final String redmineUrl;
    private final RedmineCommunicator communicator;

    public ComplementRedmineManagerImpl(String redmineUrl, RedmineCommunicator communicator) {
        this.redmineUrl = redmineUrl;
        this.communicator = communicator;
    }

    @Override
    public String getLoginErrorMessage() {
        try {
            this.getValues("/users.json?include=memberships&limit=500&offset=0", new ContentHandler<JsonElement, Object>(){

                public Object processContent(JsonElement jsonElement) throws RedmineException {
                    ComplementRedmineManagerImpl.this.log.warn("Redmine /users.json response: " + jsonElement.toString());
                    return null;
                }
            });
        }
        catch (RedmineException e) {
            if (e.getCause() != null) {
                return e.getCause().getMessage();
            }
            return e.getMessage();
        }
        return "Unknown error, incoming result was written to JIRA log file.";
    }

    public Collection<Integer> getUserIdsForGroup(@NotNull Integer groupId) throws RedmineException {
        return this.getValues(String.format("/groups/%d.json?include=users", groupId), new ContentHandler<JsonElement, Collection<Integer>>(){

            public Collection<Integer> processContent(JsonElement rootElement) throws RedmineException {
                JsonArray users = rootElement.getAsJsonObject().getAsJsonObject("group").getAsJsonArray("users");
                ArrayList result = Lists.newArrayListWithExpectedSize((int)users.size());
                for (int i = 0; i < users.size(); ++i) {
                    JsonObject user = users.get(i).getAsJsonObject();
                    result.add(user.get("id").getAsInt());
                }
                return result;
            }
        });
    }

    @Override
    public Iterable<CustomFieldDefinition> getCustomFieldDefinitions() throws RedmineException {
        return this.getValues("/custom_fields.json", new ContentHandler<JsonElement, Iterable<CustomFieldDefinition>>(){

            public Iterable<CustomFieldDefinition> processContent(JsonElement content) throws RedmineException {
                JsonArray customFieldsArray = content.getAsJsonObject().get("custom_fields").getAsJsonArray();
                Iterable issueCutomFields = Iterables.filter((Iterable)customFieldsArray, (Predicate)new Predicate<JsonElement>(){

                    public boolean apply(JsonElement input) {
                        String customized_type = input.getAsJsonObject().get("customized_type").getAsString();
                        return "issue".equals(customized_type);
                    }
                });
                return Iterables.transform((Iterable)issueCutomFields, (Function)new Function<JsonElement, CustomFieldDefinition>(){

                    public CustomFieldDefinition apply(JsonElement input) {
                        JsonObject cf = input.getAsJsonObject();
                        ImmutableSet values = ImmutableSet.of();
                        if (cf.has("possible_values")) {
                            values = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)cf.get("possible_values").getAsJsonArray(), (Function)new Function<JsonElement, String>(){

                                public String apply(JsonElement input) {
                                    return input.getAsJsonObject().get("value").getAsString();
                                }
                            }));
                        }
                        return new CustomFieldDefinition.Builder().setMultiple(this.getBooleanOrFalse(cf, "multiple")).setName(this.getStringOrNull(cf, "name")).setId(cf.has("id") ? cf.get("id").getAsLong() : -1L).setDefaultValue(this.getStringOrNull(cf, "default_value")).setFormat(this.getStringOrNull(cf, "field_format")).setPossibleValues((Set<String>)values).setRequired(this.getBooleanOrFalse(cf, "is_required")).createCustomFieldDefinition();
                    }
                });
            }

            private boolean getBooleanOrFalse(JsonObject customFieldDefinition, String name) {
                return customFieldDefinition.has(name) && customFieldDefinition.get(name).getAsBoolean();
            }

            private String getStringOrNull(JsonObject object, String name) {
                return object.has(name) ? object.get(name).getAsString() : null;
            }
        });
    }

    @Override
    public void shutdown() {
        try {
            this.communicator.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public <R> R getValues(String requestString, final ContentHandler<JsonElement, R> handler) throws RedmineException {
        HttpGet httpGet = new HttpGet(this.redmineUrl + requestString);
        return (R)this.communicator.sendRequest((HttpRequest)httpGet, new ContentHandler<HttpResponse, R>(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public R processContent(HttpResponse content) throws RedmineException {
                Object object;
                InputStream inputStream = null;
                InputStreamReader inputStreamReader = null;
                try {
                    StatusLine statusLine = content.getStatusLine();
                    if (statusLine.getStatusCode() != 200) {
                        if (statusLine.getStatusCode() == 403) {
                            throw new IOException("Redmine server has returned CODE 403 - please make sure that you are using Redmine user with administrator permissions");
                        }
                        throw new IOException(String.format("Redmine server has returned incorrect status page - [CODE: %d] - %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                    }
                    inputStream = content.getEntity().getContent();
                    inputStreamReader = new InputStreamReader(inputStream, ComplementRedmineManagerImpl.CHARSET);
                    JsonParser jsonParser = new JsonParser();
                    JsonElement rootElement = jsonParser.parse((Reader)inputStreamReader);
                    object = handler.processContent((Object)rootElement);
                }
                catch (IOException e) {
                    try {
                        throw new RedmineException((Throwable)e);
                        catch (JsonParseException e2) {
                            throw new RedmineException((Throwable)e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(inputStreamReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((Reader)inputStreamReader);
                return object;
            }
        });
    }
}

